/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.TrustListValidationOptions;
import com.prosysopc.ua.types.opcua.TrustListType;
import com.prosysopc.ua.types.opcua.server.FileTypeNode;
import com.prosysopc.ua.types.opcua.server.TrustListTypeAddCertificateMethod;
import com.prosysopc.ua.types.opcua.server.TrustListTypeCloseAndUpdateMethod;
import com.prosysopc.ua.types.opcua.server.TrustListTypeNode;
import com.prosysopc.ua.types.opcua.server.TrustListTypeOpenWithMasksMethod;
import com.prosysopc.ua.types.opcua.server.TrustListTypeRemoveCertificateMethod;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=12522")
public abstract class TrustListTypeNodeBase
extends FileTypeNode
implements TrustListType {
    private static GeneratedNodeInitializer<TrustListTypeNode> Op;
    private static TrustListTypeAddCertificateMethod Oq;
    private static TrustListTypeOpenWithMasksMethod Os;
    private static TrustListTypeRemoveCertificateMethod Ot;
    private static TrustListTypeCloseAndUpdateMethod Ou;

    protected TrustListTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<TrustListTypeNode> generatedNodeInitializer = TrustListTypeNodeBase.getTrustListTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((TrustListTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<TrustListTypeNode> getTrustListTypeNodeInitializer() {
        return Op;
    }

    public static void setTrustListTypeNodeInitializer(GeneratedNodeInitializer<TrustListTypeNode> generatedNodeInitializer) {
        Op = generatedNodeInitializer;
    }

    @Override
    @Optional
    public UaProperty getUpdateFrequencyNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "UpdateFrequency");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Double getUpdateFrequency() {
        UaProperty uaProperty = this.getUpdateFrequencyNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Optional
    public void setUpdateFrequency(Double d2) {
        UaProperty uaProperty = this.getUpdateFrequencyNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting UpdateFrequency failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting UpdateFrequency failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getLastUpdateTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LastUpdateTime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getLastUpdateTime() {
        UaProperty uaProperty = this.getLastUpdateTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node LastUpdateTime does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setLastUpdateTime(DateTime dateTime) {
        UaProperty uaProperty = this.getLastUpdateTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting LastUpdateTime failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(dateTime);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting LastUpdateTime failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getDefaultValidationOptionsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DefaultValidationOptions");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public TrustListValidationOptions getDefaultValidationOptions() {
        UaProperty uaProperty = this.getDefaultValidationOptionsNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (TrustListValidationOptions)object;
    }

    @Override
    @Optional
    public void setDefaultValidationOptions(TrustListValidationOptions trustListValidationOptions) {
        UaProperty uaProperty = this.getDefaultValidationOptionsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DefaultValidationOptions failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(trustListValidationOptions);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DefaultValidationOptions failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getActivityTimeoutNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ActivityTimeout");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Double getActivityTimeout() {
        UaProperty uaProperty = this.getActivityTimeoutNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Optional
    public void setActivityTimeout(Double d2) {
        UaProperty uaProperty = this.getActivityTimeoutNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ActivityTimeout failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ActivityTimeout failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "AddCertificate"), nodeId)) {
            this.a(serviceContext, (ByteString)variantArray[0].getValue(), (Boolean)variantArray[1].getValue());
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "OpenWithMasks"), nodeId)) {
            return new Variant[]{new Variant(this.f(serviceContext, (UnsignedInteger)variantArray[0].getValue()))};
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveCertificate"), nodeId)) {
            this.b(serviceContext, (String)variantArray[0].getValue(), (Boolean)variantArray[1].getValue());
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "CloseAndUpdate"), nodeId)) {
            return new Variant[]{new Variant(this.g(serviceContext, (UnsignedInteger)variantArray[0].getValue()))};
        }
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    @Mandatory
    public UaMethod getAddCertificateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AddCertificate");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onAddCertificate(ServiceContext var1, ByteString var2, Boolean var3) throws StatusException;

    @Override
    public void addCertificate(ByteString byteString, Boolean bl) throws StatusException {
        this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, byteString, bl);
    }

    private void a(ServiceContext serviceContext, ByteString byteString, Boolean bl) throws StatusException {
        TrustListTypeAddCertificateMethod trustListTypeAddCertificateMethod = TrustListTypeNodeBase.getAddCertificateMethodImplementation();
        if (trustListTypeAddCertificateMethod != null) {
            trustListTypeAddCertificateMethod.addCertificate(serviceContext, (TrustListTypeNode)this, byteString, bl);
        } else {
            this.onAddCertificate(serviceContext, byteString, bl);
        }
    }

    public static TrustListTypeAddCertificateMethod getAddCertificateMethodImplementation() {
        return Oq;
    }

    public static void setAddCertificateMethodImplementation(TrustListTypeAddCertificateMethod trustListTypeAddCertificateMethod) {
        Oq = trustListTypeAddCertificateMethod;
    }

    @Override
    @Mandatory
    public UaMethod getOpenWithMasksNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "OpenWithMasks");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract UnsignedInteger onOpenWithMasks(ServiceContext var1, UnsignedInteger var2) throws StatusException;

    @Override
    public UnsignedInteger openWithMasks(UnsignedInteger unsignedInteger) throws StatusException {
        return this.f(ServiceContext.INTERNAL_OPERATION_CONTEXT, unsignedInteger);
    }

    private UnsignedInteger f(ServiceContext serviceContext, UnsignedInteger unsignedInteger) throws StatusException {
        TrustListTypeOpenWithMasksMethod trustListTypeOpenWithMasksMethod = TrustListTypeNodeBase.getOpenWithMasksMethodImplementation();
        if (trustListTypeOpenWithMasksMethod != null) {
            return trustListTypeOpenWithMasksMethod.openWithMasks(serviceContext, (TrustListTypeNode)this, unsignedInteger);
        }
        return this.onOpenWithMasks(serviceContext, unsignedInteger);
    }

    public static TrustListTypeOpenWithMasksMethod getOpenWithMasksMethodImplementation() {
        return Os;
    }

    public static void setOpenWithMasksMethodImplementation(TrustListTypeOpenWithMasksMethod trustListTypeOpenWithMasksMethod) {
        Os = trustListTypeOpenWithMasksMethod;
    }

    @Override
    @Mandatory
    public UaMethod getRemoveCertificateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveCertificate");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onRemoveCertificate(ServiceContext var1, String var2, Boolean var3) throws StatusException;

    @Override
    public void removeCertificate(String string, Boolean bl) throws StatusException {
        this.b(ServiceContext.INTERNAL_OPERATION_CONTEXT, string, bl);
    }

    private void b(ServiceContext serviceContext, String string, Boolean bl) throws StatusException {
        TrustListTypeRemoveCertificateMethod trustListTypeRemoveCertificateMethod = TrustListTypeNodeBase.getRemoveCertificateMethodImplementation();
        if (trustListTypeRemoveCertificateMethod != null) {
            trustListTypeRemoveCertificateMethod.removeCertificate(serviceContext, (TrustListTypeNode)this, string, bl);
        } else {
            this.onRemoveCertificate(serviceContext, string, bl);
        }
    }

    public static TrustListTypeRemoveCertificateMethod getRemoveCertificateMethodImplementation() {
        return Ot;
    }

    public static void setRemoveCertificateMethodImplementation(TrustListTypeRemoveCertificateMethod trustListTypeRemoveCertificateMethod) {
        Ot = trustListTypeRemoveCertificateMethod;
    }

    @Override
    @Mandatory
    public UaMethod getCloseAndUpdateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CloseAndUpdate");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract Boolean onCloseAndUpdate(ServiceContext var1, UnsignedInteger var2) throws StatusException;

    @Override
    public Boolean closeAndUpdate(UnsignedInteger unsignedInteger) throws StatusException {
        return this.g(ServiceContext.INTERNAL_OPERATION_CONTEXT, unsignedInteger);
    }

    private Boolean g(ServiceContext serviceContext, UnsignedInteger unsignedInteger) throws StatusException {
        TrustListTypeCloseAndUpdateMethod trustListTypeCloseAndUpdateMethod = TrustListTypeNodeBase.getCloseAndUpdateMethodImplementation();
        if (trustListTypeCloseAndUpdateMethod != null) {
            return trustListTypeCloseAndUpdateMethod.closeAndUpdate(serviceContext, (TrustListTypeNode)this, unsignedInteger);
        }
        return this.onCloseAndUpdate(serviceContext, unsignedInteger);
    }

    public static TrustListTypeCloseAndUpdateMethod getCloseAndUpdateMethodImplementation() {
        return Ou;
    }

    public static void setCloseAndUpdateMethodImplementation(TrustListTypeCloseAndUpdateMethod trustListTypeCloseAndUpdateMethod) {
        Ou = trustListTypeCloseAndUpdateMethod;
    }
}

