/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.types.opcua.ThreeDVectorType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.ThreeDVectorTypeNode;
import com.prosysopc.ua.types.opcua.server.VectorTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=17716")
public abstract class ThreeDVectorTypeNodeBase
extends VectorTypeNode
implements ThreeDVectorType {
    private static GeneratedNodeInitializer<ThreeDVectorTypeNode> Og;

    protected ThreeDVectorTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getYNode());
        this.callAfterCreateIfExists(this.getXNode());
        this.callAfterCreateIfExists(this.getZNode());
        GeneratedNodeInitializer<ThreeDVectorTypeNode> generatedNodeInitializer = ThreeDVectorTypeNodeBase.getThreeDVectorTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((ThreeDVectorTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<ThreeDVectorTypeNode> getThreeDVectorTypeNodeInitializer() {
        return Og;
    }

    public static void setThreeDVectorTypeNodeInitializer(GeneratedNodeInitializer<ThreeDVectorTypeNode> generatedNodeInitializer) {
        Og = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getYNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Y");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getY() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getYNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node Y does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setY(Double d2) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getYNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting Y failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Y failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getXNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "X");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getX() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getXNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node X does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setX(Double d2) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getXNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting X failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting X failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getZNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Z");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getZ() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getZNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node Z does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setZ(Double d2) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getZNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting Z failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Z failed unexpectedly", statusException);
        }
    }
}

