/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.core.ThreeDCartesianCoordinates;
import com.prosysopc.ua.stack.core.ThreeDOrientation;
import com.prosysopc.ua.types.opcua.ThreeDFrameType;
import com.prosysopc.ua.types.opcua.server.FrameTypeNode;
import com.prosysopc.ua.types.opcua.server.ThreeDCartesianCoordinatesTypeNode;
import com.prosysopc.ua.types.opcua.server.ThreeDFrameTypeNode;
import com.prosysopc.ua.types.opcua.server.ThreeDOrientationTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=18791")
public abstract class ThreeDFrameTypeNodeBase
extends FrameTypeNode
implements ThreeDFrameType {
    private static GeneratedNodeInitializer<ThreeDFrameTypeNode> Oe;

    protected ThreeDFrameTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getCartesianCoordinatesNode());
        this.callAfterCreateIfExists(this.getOrientationNode());
        GeneratedNodeInitializer<ThreeDFrameTypeNode> generatedNodeInitializer = ThreeDFrameTypeNodeBase.getThreeDFrameTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((ThreeDFrameTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<ThreeDFrameTypeNode> getThreeDFrameTypeNodeInitializer() {
        return Oe;
    }

    public static void setThreeDFrameTypeNodeInitializer(GeneratedNodeInitializer<ThreeDFrameTypeNode> generatedNodeInitializer) {
        Oe = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public ThreeDCartesianCoordinatesTypeNode getCartesianCoordinatesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CartesianCoordinates");
        return (ThreeDCartesianCoordinatesTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ThreeDCartesianCoordinates getCartesianCoordinates() {
        ThreeDCartesianCoordinatesTypeNode threeDCartesianCoordinatesTypeNode = this.getCartesianCoordinatesNode();
        if (threeDCartesianCoordinatesTypeNode == null) {
            throw new RuntimeException("Mandatory node CartesianCoordinates does not exist");
        }
        Object object = threeDCartesianCoordinatesTypeNode.getValue().getValue().getValue();
        return (ThreeDCartesianCoordinates)object;
    }

    @Override
    @Mandatory
    public void setCartesianCoordinates(ThreeDCartesianCoordinates threeDCartesianCoordinates) {
        ThreeDCartesianCoordinatesTypeNode threeDCartesianCoordinatesTypeNode = this.getCartesianCoordinatesNode();
        if (threeDCartesianCoordinatesTypeNode == null) {
            throw new RuntimeException("Setting CartesianCoordinates failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            threeDCartesianCoordinatesTypeNode.setValue(threeDCartesianCoordinates);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting CartesianCoordinates failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public ThreeDOrientationTypeNode getOrientationNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Orientation");
        return (ThreeDOrientationTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ThreeDOrientation getOrientation() {
        ThreeDOrientationTypeNode threeDOrientationTypeNode = this.getOrientationNode();
        if (threeDOrientationTypeNode == null) {
            throw new RuntimeException("Mandatory node Orientation does not exist");
        }
        Object object = threeDOrientationTypeNode.getValue().getValue().getValue();
        return (ThreeDOrientation)object;
    }

    @Override
    @Mandatory
    public void setOrientation(ThreeDOrientation threeDOrientation) {
        ThreeDOrientationTypeNode threeDOrientationTypeNode = this.getOrientationNode();
        if (threeDOrientationTypeNode == null) {
            throw new RuntimeException("Setting Orientation failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            threeDOrientationTypeNode.setValue(threeDOrientation);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Orientation failed unexpectedly", statusException);
        }
    }
}

