/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.ShelvedStateMachineType;
import com.prosysopc.ua.types.opcua.server.FiniteStateMachineTypeNode;
import com.prosysopc.ua.types.opcua.server.ShelvedStateMachineTypeNode;
import com.prosysopc.ua.types.opcua.server.ShelvedStateMachineTypeOneShotShelve2Method;
import com.prosysopc.ua.types.opcua.server.ShelvedStateMachineTypeOneShotShelveMethod;
import com.prosysopc.ua.types.opcua.server.ShelvedStateMachineTypeTimedShelve2Method;
import com.prosysopc.ua.types.opcua.server.ShelvedStateMachineTypeTimedShelveMethod;
import com.prosysopc.ua.types.opcua.server.ShelvedStateMachineTypeUnshelve2Method;
import com.prosysopc.ua.types.opcua.server.ShelvedStateMachineTypeUnshelveMethod;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2929")
public abstract class ShelvedStateMachineTypeNodeBase
extends FiniteStateMachineTypeNode
implements ShelvedStateMachineType {
    private static GeneratedNodeInitializer<ShelvedStateMachineTypeNode> Nu;
    private static ShelvedStateMachineTypeTimedShelveMethod Nv;
    private static ShelvedStateMachineTypeUnshelveMethod Nw;
    private static ShelvedStateMachineTypeTimedShelve2Method Nx;
    private static ShelvedStateMachineTypeOneShotShelveMethod Ny;
    private static ShelvedStateMachineTypeUnshelve2Method Nz;
    private static ShelvedStateMachineTypeOneShotShelve2Method NA;

    protected ShelvedStateMachineTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<ShelvedStateMachineTypeNode> generatedNodeInitializer = ShelvedStateMachineTypeNodeBase.getShelvedStateMachineTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((ShelvedStateMachineTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<ShelvedStateMachineTypeNode> getShelvedStateMachineTypeNodeInitializer() {
        return Nu;
    }

    public static void setShelvedStateMachineTypeNodeInitializer(GeneratedNodeInitializer<ShelvedStateMachineTypeNode> generatedNodeInitializer) {
        Nu = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getUnshelveTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "UnshelveTime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getUnshelveTime() {
        UaProperty uaProperty = this.getUnshelveTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node UnshelveTime does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setUnshelveTime(Double d2) {
        UaProperty uaProperty = this.getUnshelveTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting UnshelveTime failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting UnshelveTime failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "TimedShelve"), nodeId)) {
            this.a(serviceContext, (Double)variantArray[0].getValue());
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "Unshelve"), nodeId)) {
            this.z(serviceContext);
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "TimedShelve2"), nodeId)) {
            this.a(serviceContext, (Double)variantArray[0].getValue(), (LocalizedText)variantArray[1].getValue());
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "OneShotShelve"), nodeId)) {
            this.A(serviceContext);
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "Unshelve2"), nodeId)) {
            this.f(serviceContext, (LocalizedText)variantArray[0].getValue());
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "OneShotShelve2"), nodeId)) {
            this.g(serviceContext, (LocalizedText)variantArray[0].getValue());
            return null;
        }
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    @Mandatory
    public UaMethod getTimedShelveNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TimedShelve");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onTimedShelve(ServiceContext var1, Double var2) throws StatusException;

    @Override
    public void timedShelve(Double d2) throws StatusException {
        this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, d2);
    }

    private void a(ServiceContext serviceContext, Double d2) throws StatusException {
        ShelvedStateMachineTypeTimedShelveMethod shelvedStateMachineTypeTimedShelveMethod = ShelvedStateMachineTypeNodeBase.getTimedShelveMethodImplementation();
        if (shelvedStateMachineTypeTimedShelveMethod != null) {
            shelvedStateMachineTypeTimedShelveMethod.timedShelve(serviceContext, (ShelvedStateMachineTypeNode)this, d2);
        } else {
            this.onTimedShelve(serviceContext, d2);
        }
    }

    public static ShelvedStateMachineTypeTimedShelveMethod getTimedShelveMethodImplementation() {
        return Nv;
    }

    public static void setTimedShelveMethodImplementation(ShelvedStateMachineTypeTimedShelveMethod shelvedStateMachineTypeTimedShelveMethod) {
        Nv = shelvedStateMachineTypeTimedShelveMethod;
    }

    @Override
    @Mandatory
    public UaMethod getUnshelveNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Unshelve");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onUnshelve(ServiceContext var1) throws StatusException;

    @Override
    public void unshelve() throws StatusException {
        this.z(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    private void z(ServiceContext serviceContext) throws StatusException {
        ShelvedStateMachineTypeUnshelveMethod shelvedStateMachineTypeUnshelveMethod = ShelvedStateMachineTypeNodeBase.getUnshelveMethodImplementation();
        if (shelvedStateMachineTypeUnshelveMethod != null) {
            shelvedStateMachineTypeUnshelveMethod.unshelve(serviceContext, (ShelvedStateMachineTypeNode)this);
        } else {
            this.onUnshelve(serviceContext);
        }
    }

    public static ShelvedStateMachineTypeUnshelveMethod getUnshelveMethodImplementation() {
        return Nw;
    }

    public static void setUnshelveMethodImplementation(ShelvedStateMachineTypeUnshelveMethod shelvedStateMachineTypeUnshelveMethod) {
        Nw = shelvedStateMachineTypeUnshelveMethod;
    }

    @Override
    @Optional
    public UaMethod getTimedShelve2Node() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TimedShelve2");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onTimedShelve2(ServiceContext var1, Double var2, LocalizedText var3) throws StatusException;

    @Override
    public void timedShelve2(Double d2, LocalizedText localizedText) throws StatusException {
        this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, d2, localizedText);
    }

    private void a(ServiceContext serviceContext, Double d2, LocalizedText localizedText) throws StatusException {
        ShelvedStateMachineTypeTimedShelve2Method shelvedStateMachineTypeTimedShelve2Method = ShelvedStateMachineTypeNodeBase.getTimedShelve2MethodImplementation();
        if (shelvedStateMachineTypeTimedShelve2Method != null) {
            shelvedStateMachineTypeTimedShelve2Method.timedShelve2(serviceContext, (ShelvedStateMachineTypeNode)this, d2, localizedText);
        } else {
            this.onTimedShelve2(serviceContext, d2, localizedText);
        }
    }

    public static ShelvedStateMachineTypeTimedShelve2Method getTimedShelve2MethodImplementation() {
        return Nx;
    }

    public static void setTimedShelve2MethodImplementation(ShelvedStateMachineTypeTimedShelve2Method shelvedStateMachineTypeTimedShelve2Method) {
        Nx = shelvedStateMachineTypeTimedShelve2Method;
    }

    @Override
    @Mandatory
    public UaMethod getOneShotShelveNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "OneShotShelve");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onOneShotShelve(ServiceContext var1) throws StatusException;

    @Override
    public void oneShotShelve() throws StatusException {
        this.A(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    private void A(ServiceContext serviceContext) throws StatusException {
        ShelvedStateMachineTypeOneShotShelveMethod shelvedStateMachineTypeOneShotShelveMethod = ShelvedStateMachineTypeNodeBase.getOneShotShelveMethodImplementation();
        if (shelvedStateMachineTypeOneShotShelveMethod != null) {
            shelvedStateMachineTypeOneShotShelveMethod.oneShotShelve(serviceContext, (ShelvedStateMachineTypeNode)this);
        } else {
            this.onOneShotShelve(serviceContext);
        }
    }

    public static ShelvedStateMachineTypeOneShotShelveMethod getOneShotShelveMethodImplementation() {
        return Ny;
    }

    public static void setOneShotShelveMethodImplementation(ShelvedStateMachineTypeOneShotShelveMethod shelvedStateMachineTypeOneShotShelveMethod) {
        Ny = shelvedStateMachineTypeOneShotShelveMethod;
    }

    @Override
    @Optional
    public UaMethod getUnshelve2Node() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Unshelve2");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onUnshelve2(ServiceContext var1, LocalizedText var2) throws StatusException;

    @Override
    public void unshelve2(LocalizedText localizedText) throws StatusException {
        this.f(ServiceContext.INTERNAL_OPERATION_CONTEXT, localizedText);
    }

    private void f(ServiceContext serviceContext, LocalizedText localizedText) throws StatusException {
        ShelvedStateMachineTypeUnshelve2Method shelvedStateMachineTypeUnshelve2Method = ShelvedStateMachineTypeNodeBase.getUnshelve2MethodImplementation();
        if (shelvedStateMachineTypeUnshelve2Method != null) {
            shelvedStateMachineTypeUnshelve2Method.unshelve2(serviceContext, (ShelvedStateMachineTypeNode)this, localizedText);
        } else {
            this.onUnshelve2(serviceContext, localizedText);
        }
    }

    public static ShelvedStateMachineTypeUnshelve2Method getUnshelve2MethodImplementation() {
        return Nz;
    }

    public static void setUnshelve2MethodImplementation(ShelvedStateMachineTypeUnshelve2Method shelvedStateMachineTypeUnshelve2Method) {
        Nz = shelvedStateMachineTypeUnshelve2Method;
    }

    @Override
    @Optional
    public UaMethod getOneShotShelve2Node() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "OneShotShelve2");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onOneShotShelve2(ServiceContext var1, LocalizedText var2) throws StatusException;

    @Override
    public void oneShotShelve2(LocalizedText localizedText) throws StatusException {
        this.g(ServiceContext.INTERNAL_OPERATION_CONTEXT, localizedText);
    }

    private void g(ServiceContext serviceContext, LocalizedText localizedText) throws StatusException {
        ShelvedStateMachineTypeOneShotShelve2Method shelvedStateMachineTypeOneShotShelve2Method = ShelvedStateMachineTypeNodeBase.getOneShotShelve2MethodImplementation();
        if (shelvedStateMachineTypeOneShotShelve2Method != null) {
            shelvedStateMachineTypeOneShotShelve2Method.oneShotShelve2(serviceContext, (ShelvedStateMachineTypeNode)this, localizedText);
        } else {
            this.onOneShotShelve2(serviceContext, localizedText);
        }
    }

    public static ShelvedStateMachineTypeOneShotShelve2Method getOneShotShelve2MethodImplementation() {
        return NA;
    }

    public static void setOneShotShelve2MethodImplementation(ShelvedStateMachineTypeOneShotShelve2Method shelvedStateMachineTypeOneShotShelve2Method) {
        NA = shelvedStateMachineTypeOneShotShelve2Method;
    }
}

