/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.RedundancySupport;
import com.prosysopc.ua.stack.core.RedundantServerDataType;
import com.prosysopc.ua.types.opcua.ServerRedundancyType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.ServerRedundancyTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2034")
public abstract class ServerRedundancyTypeNodeBase
extends BaseObjectTypeNode
implements ServerRedundancyType {
    private static GeneratedNodeInitializer<ServerRedundancyTypeNode> MZ;

    protected ServerRedundancyTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<ServerRedundancyTypeNode> generatedNodeInitializer = ServerRedundancyTypeNodeBase.getServerRedundancyTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((ServerRedundancyTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<ServerRedundancyTypeNode> getServerRedundancyTypeNodeInitializer() {
        return MZ;
    }

    public static void setServerRedundancyTypeNodeInitializer(GeneratedNodeInitializer<ServerRedundancyTypeNode> generatedNodeInitializer) {
        MZ = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getRedundancySupportNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RedundancySupport");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public RedundancySupport getRedundancySupport() {
        UaProperty uaProperty = this.getRedundancySupportNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node RedundancySupport does not exist");
        }
        Variant variant = uaProperty.getValue().getValue();
        return (RedundancySupport)variant.asEnum(RedundancySupport.class);
    }

    @Override
    @Mandatory
    public void setRedundancySupport(RedundancySupport redundancySupport) {
        UaProperty uaProperty = this.getRedundancySupportNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting RedundancySupport failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(redundancySupport);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting RedundancySupport failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getRedundantServerArrayNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RedundantServerArray");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public RedundantServerDataType[] getRedundantServerArray() {
        UaProperty uaProperty = this.getRedundantServerArrayNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (RedundantServerDataType[])object;
    }

    @Override
    @Optional
    public void setRedundantServerArray(RedundantServerDataType[] redundantServerDataTypeArray) {
        UaProperty uaProperty = this.getRedundantServerArrayNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting RedundantServerArray failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(redundantServerDataTypeArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting RedundantServerArray failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

