/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.SamplingIntervalDiagnosticsDataType;
import com.prosysopc.ua.stack.core.ServerDiagnosticsSummaryDataType;
import com.prosysopc.ua.stack.core.SubscriptionDiagnosticsDataType;
import com.prosysopc.ua.types.opcua.ServerDiagnosticsType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.SamplingIntervalDiagnosticsArrayTypeNode;
import com.prosysopc.ua.types.opcua.server.ServerDiagnosticsSummaryTypeNode;
import com.prosysopc.ua.types.opcua.server.ServerDiagnosticsTypeNode;
import com.prosysopc.ua.types.opcua.server.SessionsDiagnosticsSummaryTypeNode;
import com.prosysopc.ua.types.opcua.server.SubscriptionDiagnosticsArrayTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2020")
public abstract class ServerDiagnosticsTypeNodeBase
extends BaseObjectTypeNode
implements ServerDiagnosticsType {
    private static GeneratedNodeInitializer<ServerDiagnosticsTypeNode> MY;

    protected ServerDiagnosticsTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getServerDiagnosticsSummaryNode());
        this.callAfterCreateIfExists(this.getSubscriptionDiagnosticsArrayNode());
        this.callAfterCreateIfExists(this.getSamplingIntervalDiagnosticsArrayNode());
        this.callAfterCreateIfExists(this.getSessionsDiagnosticsSummaryNode());
        GeneratedNodeInitializer<ServerDiagnosticsTypeNode> generatedNodeInitializer = ServerDiagnosticsTypeNodeBase.getServerDiagnosticsTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((ServerDiagnosticsTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<ServerDiagnosticsTypeNode> getServerDiagnosticsTypeNodeInitializer() {
        return MY;
    }

    public static void setServerDiagnosticsTypeNodeInitializer(GeneratedNodeInitializer<ServerDiagnosticsTypeNode> generatedNodeInitializer) {
        MY = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getEnabledFlagNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EnabledFlag");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isEnabledFlag() {
        UaProperty uaProperty = this.getEnabledFlagNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node EnabledFlag does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setEnabledFlag(Boolean bl) {
        UaProperty uaProperty = this.getEnabledFlagNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EnabledFlag failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(bl);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting EnabledFlag failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public ServerDiagnosticsSummaryTypeNode getServerDiagnosticsSummaryNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ServerDiagnosticsSummary");
        return (ServerDiagnosticsSummaryTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServerDiagnosticsSummaryDataType getServerDiagnosticsSummary() {
        ServerDiagnosticsSummaryTypeNode serverDiagnosticsSummaryTypeNode = this.getServerDiagnosticsSummaryNode();
        if (serverDiagnosticsSummaryTypeNode == null) {
            throw new RuntimeException("Mandatory node ServerDiagnosticsSummary does not exist");
        }
        Object object = serverDiagnosticsSummaryTypeNode.getValue().getValue().getValue();
        return (ServerDiagnosticsSummaryDataType)object;
    }

    @Override
    @Mandatory
    public void setServerDiagnosticsSummary(ServerDiagnosticsSummaryDataType serverDiagnosticsSummaryDataType) {
        ServerDiagnosticsSummaryTypeNode serverDiagnosticsSummaryTypeNode = this.getServerDiagnosticsSummaryNode();
        if (serverDiagnosticsSummaryTypeNode == null) {
            throw new RuntimeException("Setting ServerDiagnosticsSummary failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            serverDiagnosticsSummaryTypeNode.setValue(serverDiagnosticsSummaryDataType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ServerDiagnosticsSummary failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public SubscriptionDiagnosticsArrayTypeNode getSubscriptionDiagnosticsArrayNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SubscriptionDiagnosticsArray");
        return (SubscriptionDiagnosticsArrayTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public SubscriptionDiagnosticsDataType[] getSubscriptionDiagnosticsArray() {
        SubscriptionDiagnosticsArrayTypeNode subscriptionDiagnosticsArrayTypeNode = this.getSubscriptionDiagnosticsArrayNode();
        if (subscriptionDiagnosticsArrayTypeNode == null) {
            throw new RuntimeException("Mandatory node SubscriptionDiagnosticsArray does not exist");
        }
        Object object = subscriptionDiagnosticsArrayTypeNode.getValue().getValue().getValue();
        return (SubscriptionDiagnosticsDataType[])object;
    }

    @Override
    @Mandatory
    public void setSubscriptionDiagnosticsArray(SubscriptionDiagnosticsDataType[] subscriptionDiagnosticsDataTypeArray) {
        SubscriptionDiagnosticsArrayTypeNode subscriptionDiagnosticsArrayTypeNode = this.getSubscriptionDiagnosticsArrayNode();
        if (subscriptionDiagnosticsArrayTypeNode == null) {
            throw new RuntimeException("Setting SubscriptionDiagnosticsArray failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            subscriptionDiagnosticsArrayTypeNode.setValue(subscriptionDiagnosticsDataTypeArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SubscriptionDiagnosticsArray failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public SamplingIntervalDiagnosticsArrayTypeNode getSamplingIntervalDiagnosticsArrayNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SamplingIntervalDiagnosticsArray");
        return (SamplingIntervalDiagnosticsArrayTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public SamplingIntervalDiagnosticsDataType[] getSamplingIntervalDiagnosticsArray() {
        SamplingIntervalDiagnosticsArrayTypeNode samplingIntervalDiagnosticsArrayTypeNode = this.getSamplingIntervalDiagnosticsArrayNode();
        if (samplingIntervalDiagnosticsArrayTypeNode == null) {
            return null;
        }
        Object object = samplingIntervalDiagnosticsArrayTypeNode.getValue().getValue().getValue();
        return (SamplingIntervalDiagnosticsDataType[])object;
    }

    @Override
    @Optional
    public void setSamplingIntervalDiagnosticsArray(SamplingIntervalDiagnosticsDataType[] samplingIntervalDiagnosticsDataTypeArray) {
        SamplingIntervalDiagnosticsArrayTypeNode samplingIntervalDiagnosticsArrayTypeNode = this.getSamplingIntervalDiagnosticsArrayNode();
        if (samplingIntervalDiagnosticsArrayTypeNode == null) {
            throw new RuntimeException("Setting SamplingIntervalDiagnosticsArray failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            samplingIntervalDiagnosticsArrayTypeNode.setValue(samplingIntervalDiagnosticsDataTypeArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SamplingIntervalDiagnosticsArray failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public SessionsDiagnosticsSummaryTypeNode getSessionsDiagnosticsSummaryNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SessionsDiagnosticsSummary");
        return (SessionsDiagnosticsSummaryTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

