/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.SignedSoftwareCertificate;
import com.prosysopc.ua.types.opcua.ServerCapabilitiesType;
import com.prosysopc.ua.types.opcua.ServerVendorCapabilityType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.FolderTypeNode;
import com.prosysopc.ua.types.opcua.server.OperationLimitsTypeNode;
import com.prosysopc.ua.types.opcua.server.RoleSetTypeNode;
import com.prosysopc.ua.types.opcua.server.ServerCapabilitiesTypeNode;
import java.util.List;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2013")
public abstract class ServerCapabilitiesTypeNodeBase
extends BaseObjectTypeNode
implements ServerCapabilitiesType {
    private static GeneratedNodeInitializer<ServerCapabilitiesTypeNode> MO;

    protected ServerCapabilitiesTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getAggregateFunctionsNode());
        this.callAfterCreateIfExists(this.getModellingRulesNode());
        this.callAfterCreateIfExists(this.getOperationLimitsNode());
        this.callAfterCreateIfExists(this.getRoleSetNode());
        GeneratedNodeInitializer<ServerCapabilitiesTypeNode> generatedNodeInitializer = ServerCapabilitiesTypeNodeBase.getServerCapabilitiesTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((ServerCapabilitiesTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<ServerCapabilitiesTypeNode> getServerCapabilitiesTypeNodeInitializer() {
        return MO;
    }

    public static void setServerCapabilitiesTypeNodeInitializer(GeneratedNodeInitializer<ServerCapabilitiesTypeNode> generatedNodeInitializer) {
        MO = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getMinSupportedSampleRateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MinSupportedSampleRate");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getMinSupportedSampleRate() {
        UaProperty uaProperty = this.getMinSupportedSampleRateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node MinSupportedSampleRate does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setMinSupportedSampleRate(Double d2) {
        UaProperty uaProperty = this.getMinSupportedSampleRateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MinSupportedSampleRate failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MinSupportedSampleRate failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getMaxArrayLengthNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxArrayLength");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getMaxArrayLength() {
        UaProperty uaProperty = this.getMaxArrayLengthNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setMaxArrayLength(UnsignedInteger unsignedInteger) {
        UaProperty uaProperty = this.getMaxArrayLengthNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxArrayLength failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MaxArrayLength failed unexpectedly", statusException);
        }
    }

    public void setMaxArrayLength(long l2) {
        this.setMaxArrayLength(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public UaProperty getMaxQueryContinuationPointsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxQueryContinuationPoints");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getMaxQueryContinuationPoints() {
        UaProperty uaProperty = this.getMaxQueryContinuationPointsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node MaxQueryContinuationPoints does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setMaxQueryContinuationPoints(UnsignedShort unsignedShort) {
        UaProperty uaProperty = this.getMaxQueryContinuationPointsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxQueryContinuationPoints failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedShort);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MaxQueryContinuationPoints failed unexpectedly", statusException);
        }
    }

    public void setMaxQueryContinuationPoints(int n2) {
        this.setMaxQueryContinuationPoints(UnsignedShort.valueOf(n2));
    }

    @Override
    @Optional
    public UaProperty getMaxStringLengthNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxStringLength");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getMaxStringLength() {
        UaProperty uaProperty = this.getMaxStringLengthNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setMaxStringLength(UnsignedInteger unsignedInteger) {
        UaProperty uaProperty = this.getMaxStringLengthNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxStringLength failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MaxStringLength failed unexpectedly", statusException);
        }
    }

    public void setMaxStringLength(long l2) {
        this.setMaxStringLength(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Optional
    public UaProperty getMaxSessionsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxSessions");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getMaxSessions() {
        UaProperty uaProperty = this.getMaxSessionsNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setMaxSessions(UnsignedInteger unsignedInteger) {
        UaProperty uaProperty = this.getMaxSessionsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxSessions failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MaxSessions failed unexpectedly", statusException);
        }
    }

    public void setMaxSessions(long l2) {
        this.setMaxSessions(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Optional
    public UaProperty getMaxSelectClauseParametersNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxSelectClauseParameters");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getMaxSelectClauseParameters() {
        UaProperty uaProperty = this.getMaxSelectClauseParametersNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setMaxSelectClauseParameters(UnsignedInteger unsignedInteger) {
        UaProperty uaProperty = this.getMaxSelectClauseParametersNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxSelectClauseParameters failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MaxSelectClauseParameters failed unexpectedly", statusException);
        }
    }

    public void setMaxSelectClauseParameters(long l2) {
        this.setMaxSelectClauseParameters(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Optional
    public UaProperty getConformanceUnitsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ConformanceUnits");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public QualifiedName[] getConformanceUnits() {
        UaProperty uaProperty = this.getConformanceUnitsNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (QualifiedName[])object;
    }

    @Override
    @Optional
    public void setConformanceUnits(QualifiedName[] qualifiedNameArray) {
        UaProperty uaProperty = this.getConformanceUnitsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ConformanceUnits failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(qualifiedNameArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ConformanceUnits failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getServerProfileArrayNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ServerProfileArray");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String[] getServerProfileArray() {
        UaProperty uaProperty = this.getServerProfileArrayNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ServerProfileArray does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String[])object;
    }

    @Override
    @Mandatory
    public void setServerProfileArray(String[] stringArray) {
        UaProperty uaProperty = this.getServerProfileArrayNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ServerProfileArray failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(stringArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ServerProfileArray failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getMaxSubscriptionsPerSessionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxSubscriptionsPerSession");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getMaxSubscriptionsPerSession() {
        UaProperty uaProperty = this.getMaxSubscriptionsPerSessionNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setMaxSubscriptionsPerSession(UnsignedInteger unsignedInteger) {
        UaProperty uaProperty = this.getMaxSubscriptionsPerSessionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxSubscriptionsPerSession failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MaxSubscriptionsPerSession failed unexpectedly", statusException);
        }
    }

    public void setMaxSubscriptionsPerSession(long l2) {
        this.setMaxSubscriptionsPerSession(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public UaProperty getMaxHistoryContinuationPointsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxHistoryContinuationPoints");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getMaxHistoryContinuationPoints() {
        UaProperty uaProperty = this.getMaxHistoryContinuationPointsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node MaxHistoryContinuationPoints does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setMaxHistoryContinuationPoints(UnsignedShort unsignedShort) {
        UaProperty uaProperty = this.getMaxHistoryContinuationPointsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxHistoryContinuationPoints failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedShort);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MaxHistoryContinuationPoints failed unexpectedly", statusException);
        }
    }

    public void setMaxHistoryContinuationPoints(int n2) {
        this.setMaxHistoryContinuationPoints(UnsignedShort.valueOf(n2));
    }

    @Override
    @Mandatory
    public UaProperty getMaxBrowseContinuationPointsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxBrowseContinuationPoints");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getMaxBrowseContinuationPoints() {
        UaProperty uaProperty = this.getMaxBrowseContinuationPointsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node MaxBrowseContinuationPoints does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setMaxBrowseContinuationPoints(UnsignedShort unsignedShort) {
        UaProperty uaProperty = this.getMaxBrowseContinuationPointsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxBrowseContinuationPoints failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedShort);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MaxBrowseContinuationPoints failed unexpectedly", statusException);
        }
    }

    public void setMaxBrowseContinuationPoints(int n2) {
        this.setMaxBrowseContinuationPoints(UnsignedShort.valueOf(n2));
    }

    @Override
    @Optional
    public UaProperty getMaxByteStringLengthNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxByteStringLength");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getMaxByteStringLength() {
        UaProperty uaProperty = this.getMaxByteStringLengthNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setMaxByteStringLength(UnsignedInteger unsignedInteger) {
        UaProperty uaProperty = this.getMaxByteStringLengthNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxByteStringLength failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MaxByteStringLength failed unexpectedly", statusException);
        }
    }

    public void setMaxByteStringLength(long l2) {
        this.setMaxByteStringLength(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Optional
    public UaProperty getMaxMonitoredItemsQueueSizeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxMonitoredItemsQueueSize");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getMaxMonitoredItemsQueueSize() {
        UaProperty uaProperty = this.getMaxMonitoredItemsQueueSizeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setMaxMonitoredItemsQueueSize(UnsignedInteger unsignedInteger) {
        UaProperty uaProperty = this.getMaxMonitoredItemsQueueSizeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxMonitoredItemsQueueSize failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MaxMonitoredItemsQueueSize failed unexpectedly", statusException);
        }
    }

    public void setMaxMonitoredItemsQueueSize(long l2) {
        this.setMaxMonitoredItemsQueueSize(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Optional
    public UaProperty getMaxMonitoredItemsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxMonitoredItems");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getMaxMonitoredItems() {
        UaProperty uaProperty = this.getMaxMonitoredItemsNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setMaxMonitoredItems(UnsignedInteger unsignedInteger) {
        UaProperty uaProperty = this.getMaxMonitoredItemsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxMonitoredItems failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MaxMonitoredItems failed unexpectedly", statusException);
        }
    }

    public void setMaxMonitoredItems(long l2) {
        this.setMaxMonitoredItems(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Optional
    public UaProperty getMaxMonitoredItemsPerSubscriptionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxMonitoredItemsPerSubscription");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getMaxMonitoredItemsPerSubscription() {
        UaProperty uaProperty = this.getMaxMonitoredItemsPerSubscriptionNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setMaxMonitoredItemsPerSubscription(UnsignedInteger unsignedInteger) {
        UaProperty uaProperty = this.getMaxMonitoredItemsPerSubscriptionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxMonitoredItemsPerSubscription failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MaxMonitoredItemsPerSubscription failed unexpectedly", statusException);
        }
    }

    public void setMaxMonitoredItemsPerSubscription(long l2) {
        this.setMaxMonitoredItemsPerSubscription(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public UaProperty getLocaleIdArrayNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LocaleIdArray");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String[] getLocaleIdArray() {
        UaProperty uaProperty = this.getLocaleIdArrayNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node LocaleIdArray does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String[])object;
    }

    @Override
    @Mandatory
    public void setLocaleIdArray(String[] stringArray) {
        UaProperty uaProperty = this.getLocaleIdArrayNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting LocaleIdArray failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(stringArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting LocaleIdArray failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getSoftwareCertificatesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SoftwareCertificates");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public SignedSoftwareCertificate[] getSoftwareCertificates() {
        UaProperty uaProperty = this.getSoftwareCertificatesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node SoftwareCertificates does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (SignedSoftwareCertificate[])object;
    }

    @Override
    @Mandatory
    public void setSoftwareCertificates(SignedSoftwareCertificate[] signedSoftwareCertificateArray) {
        UaProperty uaProperty = this.getSoftwareCertificatesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SoftwareCertificates failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(signedSoftwareCertificateArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SoftwareCertificates failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getMaxSubscriptionsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxSubscriptions");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getMaxSubscriptions() {
        UaProperty uaProperty = this.getMaxSubscriptionsNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setMaxSubscriptions(UnsignedInteger unsignedInteger) {
        UaProperty uaProperty = this.getMaxSubscriptionsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxSubscriptions failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MaxSubscriptions failed unexpectedly", statusException);
        }
    }

    public void setMaxSubscriptions(long l2) {
        this.setMaxSubscriptions(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Optional
    public UaProperty getMaxWhereClauseParametersNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxWhereClauseParameters");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getMaxWhereClauseParameters() {
        UaProperty uaProperty = this.getMaxWhereClauseParametersNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setMaxWhereClauseParameters(UnsignedInteger unsignedInteger) {
        UaProperty uaProperty = this.getMaxWhereClauseParametersNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxWhereClauseParameters failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MaxWhereClauseParameters failed unexpectedly", statusException);
        }
    }

    public void setMaxWhereClauseParameters(long l2) {
        this.setMaxWhereClauseParameters(UnsignedInteger.valueOf(l2));
    }

    @Override
    public List<? extends ServerVendorCapabilityType> getVendorCapability_PlaceholderNodes() {
        ExpandedNodeId expandedNodeId = ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=11562");
        ExpandedNodeId expandedNodeId2 = ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=47");
        return this.findPlaceholders(ServerVendorCapabilityType.class, expandedNodeId, expandedNodeId2);
    }

    @Override
    @Mandatory
    public FolderTypeNode getAggregateFunctionsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AggregateFunctions");
        return (FolderTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public FolderTypeNode getModellingRulesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ModellingRules");
        return (FolderTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public OperationLimitsTypeNode getOperationLimitsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "OperationLimits");
        return (OperationLimitsTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public RoleSetTypeNode getRoleSetNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RoleSet");
        return (RoleSetTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

