/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.SecurityGroupFolderType;
import com.prosysopc.ua.types.opcua.server.FolderTypeNode;
import com.prosysopc.ua.types.opcua.server.SecurityGroupFolderTypeAddSecurityGroupFolderMethod;
import com.prosysopc.ua.types.opcua.server.SecurityGroupFolderTypeAddSecurityGroupMethod;
import com.prosysopc.ua.types.opcua.server.SecurityGroupFolderTypeNode;
import com.prosysopc.ua.types.opcua.server.SecurityGroupFolderTypeRemoveSecurityGroupFolderMethod;
import com.prosysopc.ua.types.opcua.server.SecurityGroupFolderTypeRemoveSecurityGroupMethod;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=15452")
public abstract class SecurityGroupFolderTypeNodeBase
extends FolderTypeNode
implements SecurityGroupFolderType {
    private static GeneratedNodeInitializer<SecurityGroupFolderTypeNode> ME;
    private static SecurityGroupFolderTypeRemoveSecurityGroupFolderMethod MF;
    private static SecurityGroupFolderTypeRemoveSecurityGroupMethod MG;
    private static SecurityGroupFolderTypeAddSecurityGroupFolderMethod MH;
    private static SecurityGroupFolderTypeAddSecurityGroupMethod MI;

    protected SecurityGroupFolderTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<SecurityGroupFolderTypeNode> generatedNodeInitializer = SecurityGroupFolderTypeNodeBase.getSecurityGroupFolderTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((SecurityGroupFolderTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<SecurityGroupFolderTypeNode> getSecurityGroupFolderTypeNodeInitializer() {
        return ME;
    }

    public static void setSecurityGroupFolderTypeNodeInitializer(GeneratedNodeInitializer<SecurityGroupFolderTypeNode> generatedNodeInitializer) {
        ME = generatedNodeInitializer;
    }

    @Override
    @Optional
    public UaProperty getSupportedSecurityPolicyUrisNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SupportedSecurityPolicyUris");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String[] getSupportedSecurityPolicyUris() {
        UaProperty uaProperty = this.getSupportedSecurityPolicyUrisNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String[])object;
    }

    @Override
    @Optional
    public void setSupportedSecurityPolicyUris(String[] stringArray) {
        UaProperty uaProperty = this.getSupportedSecurityPolicyUrisNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SupportedSecurityPolicyUris failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(stringArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SupportedSecurityPolicyUris failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveSecurityGroupFolder"), nodeId)) {
            this.n(serviceContext, (NodeId)variantArray[0].getValue());
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveSecurityGroup"), nodeId)) {
            this.o(serviceContext, (NodeId)variantArray[0].getValue());
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "AddSecurityGroupFolder"), nodeId)) {
            return new Variant[]{new Variant(this.i(serviceContext, (String)variantArray[0].getValue()))};
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "AddSecurityGroup"), nodeId)) {
            return this.a(serviceContext, (String)variantArray[0].getValue(), (Double)variantArray[1].getValue(), (String)variantArray[2].getValue(), (UnsignedInteger)variantArray[3].getValue(), (UnsignedInteger)variantArray[4].getValue()).asVariantArray();
        }
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    @Optional
    public UaMethod getRemoveSecurityGroupFolderNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveSecurityGroupFolder");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onRemoveSecurityGroupFolder(ServiceContext var1, NodeId var2) throws StatusException;

    @Override
    public void removeSecurityGroupFolder(NodeId nodeId) throws StatusException {
        this.n(ServiceContext.INTERNAL_OPERATION_CONTEXT, nodeId);
    }

    private void n(ServiceContext serviceContext, NodeId nodeId) throws StatusException {
        SecurityGroupFolderTypeRemoveSecurityGroupFolderMethod securityGroupFolderTypeRemoveSecurityGroupFolderMethod = SecurityGroupFolderTypeNodeBase.getRemoveSecurityGroupFolderMethodImplementation();
        if (securityGroupFolderTypeRemoveSecurityGroupFolderMethod != null) {
            securityGroupFolderTypeRemoveSecurityGroupFolderMethod.removeSecurityGroupFolder(serviceContext, (SecurityGroupFolderTypeNode)this, nodeId);
        } else {
            this.onRemoveSecurityGroupFolder(serviceContext, nodeId);
        }
    }

    public static SecurityGroupFolderTypeRemoveSecurityGroupFolderMethod getRemoveSecurityGroupFolderMethodImplementation() {
        return MF;
    }

    public static void setRemoveSecurityGroupFolderMethodImplementation(SecurityGroupFolderTypeRemoveSecurityGroupFolderMethod securityGroupFolderTypeRemoveSecurityGroupFolderMethod) {
        MF = securityGroupFolderTypeRemoveSecurityGroupFolderMethod;
    }

    @Override
    @Mandatory
    public UaMethod getRemoveSecurityGroupNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveSecurityGroup");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onRemoveSecurityGroup(ServiceContext var1, NodeId var2) throws StatusException;

    @Override
    public void removeSecurityGroup(NodeId nodeId) throws StatusException {
        this.o(ServiceContext.INTERNAL_OPERATION_CONTEXT, nodeId);
    }

    private void o(ServiceContext serviceContext, NodeId nodeId) throws StatusException {
        SecurityGroupFolderTypeRemoveSecurityGroupMethod securityGroupFolderTypeRemoveSecurityGroupMethod = SecurityGroupFolderTypeNodeBase.getRemoveSecurityGroupMethodImplementation();
        if (securityGroupFolderTypeRemoveSecurityGroupMethod != null) {
            securityGroupFolderTypeRemoveSecurityGroupMethod.removeSecurityGroup(serviceContext, (SecurityGroupFolderTypeNode)this, nodeId);
        } else {
            this.onRemoveSecurityGroup(serviceContext, nodeId);
        }
    }

    public static SecurityGroupFolderTypeRemoveSecurityGroupMethod getRemoveSecurityGroupMethodImplementation() {
        return MG;
    }

    public static void setRemoveSecurityGroupMethodImplementation(SecurityGroupFolderTypeRemoveSecurityGroupMethod securityGroupFolderTypeRemoveSecurityGroupMethod) {
        MG = securityGroupFolderTypeRemoveSecurityGroupMethod;
    }

    @Override
    @Optional
    public UaMethod getAddSecurityGroupFolderNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AddSecurityGroupFolder");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract NodeId onAddSecurityGroupFolder(ServiceContext var1, String var2) throws StatusException;

    @Override
    public NodeId addSecurityGroupFolder(String string) throws StatusException {
        return this.i(ServiceContext.INTERNAL_OPERATION_CONTEXT, string);
    }

    private NodeId i(ServiceContext serviceContext, String string) throws StatusException {
        SecurityGroupFolderTypeAddSecurityGroupFolderMethod securityGroupFolderTypeAddSecurityGroupFolderMethod = SecurityGroupFolderTypeNodeBase.getAddSecurityGroupFolderMethodImplementation();
        if (securityGroupFolderTypeAddSecurityGroupFolderMethod != null) {
            return securityGroupFolderTypeAddSecurityGroupFolderMethod.addSecurityGroupFolder(serviceContext, (SecurityGroupFolderTypeNode)this, string);
        }
        return this.onAddSecurityGroupFolder(serviceContext, string);
    }

    public static SecurityGroupFolderTypeAddSecurityGroupFolderMethod getAddSecurityGroupFolderMethodImplementation() {
        return MH;
    }

    public static void setAddSecurityGroupFolderMethodImplementation(SecurityGroupFolderTypeAddSecurityGroupFolderMethod securityGroupFolderTypeAddSecurityGroupFolderMethod) {
        MH = securityGroupFolderTypeAddSecurityGroupFolderMethod;
    }

    @Override
    @Mandatory
    public UaMethod getAddSecurityGroupNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AddSecurityGroup");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract SecurityGroupFolderType.AddSecurityGroupMethodOutputs onAddSecurityGroup(ServiceContext var1, String var2, Double var3, String var4, UnsignedInteger var5, UnsignedInteger var6) throws StatusException;

    @Override
    public SecurityGroupFolderType.AddSecurityGroupMethodOutputs addSecurityGroup(String string, Double d2, String string2, UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2) throws StatusException {
        return this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, string, d2, string2, unsignedInteger, unsignedInteger2);
    }

    private SecurityGroupFolderType.AddSecurityGroupMethodOutputs a(ServiceContext serviceContext, String string, Double d2, String string2, UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2) throws StatusException {
        SecurityGroupFolderTypeAddSecurityGroupMethod securityGroupFolderTypeAddSecurityGroupMethod = SecurityGroupFolderTypeNodeBase.getAddSecurityGroupMethodImplementation();
        if (securityGroupFolderTypeAddSecurityGroupMethod != null) {
            return securityGroupFolderTypeAddSecurityGroupMethod.addSecurityGroup(serviceContext, (SecurityGroupFolderTypeNode)this, string, d2, string2, unsignedInteger, unsignedInteger2);
        }
        return this.onAddSecurityGroup(serviceContext, string, d2, string2, unsignedInteger, unsignedInteger2);
    }

    public static SecurityGroupFolderTypeAddSecurityGroupMethod getAddSecurityGroupMethodImplementation() {
        return MI;
    }

    public static void setAddSecurityGroupMethodImplementation(SecurityGroupFolderTypeAddSecurityGroupMethod securityGroupFolderTypeAddSecurityGroupMethod) {
        MI = securityGroupFolderTypeAddSecurityGroupMethod;
    }
}

