/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.core.ReferenceListEntryDataType;
import com.prosysopc.ua.types.opcua.ReferenceDescriptionVariableType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.ReferenceDescriptionVariableTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=32657")
public abstract class ReferenceDescriptionVariableTypeNodeBase
extends BaseDataVariableTypeNode
implements ReferenceDescriptionVariableType {
    private static GeneratedNodeInitializer<ReferenceDescriptionVariableTypeNode> Mk;

    protected ReferenceDescriptionVariableTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<ReferenceDescriptionVariableTypeNode> generatedNodeInitializer = ReferenceDescriptionVariableTypeNodeBase.getReferenceDescriptionVariableTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((ReferenceDescriptionVariableTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<ReferenceDescriptionVariableTypeNode> getReferenceDescriptionVariableTypeNodeInitializer() {
        return Mk;
    }

    public static void setReferenceDescriptionVariableTypeNodeInitializer(GeneratedNodeInitializer<ReferenceDescriptionVariableTypeNode> generatedNodeInitializer) {
        Mk = generatedNodeInitializer;
    }

    @Override
    @Optional
    public UaProperty getReferenceRefinementNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ReferenceRefinement");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public ReferenceListEntryDataType[] getReferenceRefinement() {
        UaProperty uaProperty = this.getReferenceRefinementNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (ReferenceListEntryDataType[])object;
    }

    @Override
    @Optional
    public void setReferenceRefinement(ReferenceListEntryDataType[] referenceListEntryDataTypeArray) {
        UaProperty uaProperty = this.getReferenceRefinementNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ReferenceRefinement failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(referenceListEntryDataTypeArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ReferenceRefinement failed unexpectedly", statusException);
        }
    }
}

