/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.AnnotationDataType;
import com.prosysopc.ua.stack.core.QuantityDimension;
import com.prosysopc.ua.types.opcua.QuantityType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.QuantityTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=32475")
public abstract class QuantityTypeNodeBase
extends BaseObjectTypeNode
implements QuantityType {
    private static GeneratedNodeInitializer<QuantityTypeNode> Md;

    protected QuantityTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getServerUnitsNode());
        GeneratedNodeInitializer<QuantityTypeNode> generatedNodeInitializer = QuantityTypeNodeBase.getQuantityTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((QuantityTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<QuantityTypeNode> getQuantityTypeNodeInitializer() {
        return Md;
    }

    public static void setQuantityTypeNodeInitializer(GeneratedNodeInitializer<QuantityTypeNode> generatedNodeInitializer) {
        Md = generatedNodeInitializer;
    }

    @Override
    @Optional
    public UaProperty getSymbolNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Symbol");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public LocalizedText getSymbol() {
        UaProperty uaProperty = this.getSymbolNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Optional
    public void setSymbol(LocalizedText localizedText) {
        UaProperty uaProperty = this.getSymbolNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Symbol failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(localizedText);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Symbol failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getDimensionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Dimension");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public QuantityDimension getDimension() {
        UaProperty uaProperty = this.getDimensionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node Dimension does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (QuantityDimension)object;
    }

    @Override
    @Mandatory
    public void setDimension(QuantityDimension quantityDimension) {
        UaProperty uaProperty = this.getDimensionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Dimension failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(quantityDimension);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Dimension failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getAnnotationNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Annotation");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public AnnotationDataType[] getAnnotation() {
        UaProperty uaProperty = this.getAnnotationNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (AnnotationDataType[])object;
    }

    @Override
    @Optional
    public void setAnnotation(AnnotationDataType[] annotationDataTypeArray) {
        UaProperty uaProperty = this.getAnnotationNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Annotation failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(annotationDataTypeArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Annotation failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getConversionServiceNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ConversionService");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getConversionService() {
        UaProperty uaProperty = this.getConversionServiceNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setConversionService(String string) {
        UaProperty uaProperty = this.getConversionServiceNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ConversionService failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ConversionService failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseObjectTypeNode getServerUnitsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ServerUnits");
        return (BaseObjectTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

