/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.UserTokenPolicy;
import com.prosysopc.ua.types.opcua.PubSubKeyPushTargetType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.PubSubKeyPushTargetTypeConnectSecurityGroupsMethod;
import com.prosysopc.ua.types.opcua.server.PubSubKeyPushTargetTypeDisconnectSecurityGroupsMethod;
import com.prosysopc.ua.types.opcua.server.PubSubKeyPushTargetTypeNode;
import com.prosysopc.ua.types.opcua.server.PubSubKeyPushTargetTypeTriggerKeyUpdateMethod;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=25337")
public abstract class PubSubKeyPushTargetTypeNodeBase
extends BaseObjectTypeNode
implements PubSubKeyPushTargetType {
    private static GeneratedNodeInitializer<PubSubKeyPushTargetTypeNode> LG;
    private static PubSubKeyPushTargetTypeTriggerKeyUpdateMethod LH;
    private static PubSubKeyPushTargetTypeConnectSecurityGroupsMethod LI;
    private static PubSubKeyPushTargetTypeDisconnectSecurityGroupsMethod LJ;

    protected PubSubKeyPushTargetTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<PubSubKeyPushTargetTypeNode> generatedNodeInitializer = PubSubKeyPushTargetTypeNodeBase.getPubSubKeyPushTargetTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((PubSubKeyPushTargetTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<PubSubKeyPushTargetTypeNode> getPubSubKeyPushTargetTypeNodeInitializer() {
        return LG;
    }

    public static void setPubSubKeyPushTargetTypeNodeInitializer(GeneratedNodeInitializer<PubSubKeyPushTargetTypeNode> generatedNodeInitializer) {
        LG = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getSecurityPolicyUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SecurityPolicyUri");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getSecurityPolicyUri() {
        UaProperty uaProperty = this.getSecurityPolicyUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node SecurityPolicyUri does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setSecurityPolicyUri(String string) {
        UaProperty uaProperty = this.getSecurityPolicyUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SecurityPolicyUri failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SecurityPolicyUri failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getRequestedKeyCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RequestedKeyCount");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getRequestedKeyCount() {
        UaProperty uaProperty = this.getRequestedKeyCountNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node RequestedKeyCount does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setRequestedKeyCount(UnsignedShort unsignedShort) {
        UaProperty uaProperty = this.getRequestedKeyCountNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting RequestedKeyCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedShort);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting RequestedKeyCount failed unexpectedly", statusException);
        }
    }

    public void setRequestedKeyCount(int n2) {
        this.setRequestedKeyCount(UnsignedShort.valueOf(n2));
    }

    @Override
    @Mandatory
    public UaProperty getEndpointUrlNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EndpointUrl");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getEndpointUrl() {
        UaProperty uaProperty = this.getEndpointUrlNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node EndpointUrl does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setEndpointUrl(String string) {
        UaProperty uaProperty = this.getEndpointUrlNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EndpointUrl failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting EndpointUrl failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getApplicationUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ApplicationUri");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getApplicationUri() {
        UaProperty uaProperty = this.getApplicationUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ApplicationUri does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setApplicationUri(String string) {
        UaProperty uaProperty = this.getApplicationUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ApplicationUri failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ApplicationUri failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getLastPushExecutionTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LastPushExecutionTime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getLastPushExecutionTime() {
        UaProperty uaProperty = this.getLastPushExecutionTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node LastPushExecutionTime does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setLastPushExecutionTime(DateTime dateTime) {
        UaProperty uaProperty = this.getLastPushExecutionTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting LastPushExecutionTime failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(dateTime);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting LastPushExecutionTime failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getRetryIntervalNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RetryInterval");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getRetryInterval() {
        UaProperty uaProperty = this.getRetryIntervalNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node RetryInterval does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setRetryInterval(Double d2) {
        UaProperty uaProperty = this.getRetryIntervalNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting RetryInterval failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting RetryInterval failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getLastPushErrorTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LastPushErrorTime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getLastPushErrorTime() {
        UaProperty uaProperty = this.getLastPushErrorTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node LastPushErrorTime does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setLastPushErrorTime(DateTime dateTime) {
        UaProperty uaProperty = this.getLastPushErrorTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting LastPushErrorTime failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(dateTime);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting LastPushErrorTime failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getUserTokenTypeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "UserTokenType");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UserTokenPolicy getUserTokenType() {
        UaProperty uaProperty = this.getUserTokenTypeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node UserTokenType does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UserTokenPolicy)object;
    }

    @Override
    @Mandatory
    public void setUserTokenType(UserTokenPolicy userTokenPolicy) {
        UaProperty uaProperty = this.getUserTokenTypeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting UserTokenType failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(userTokenPolicy);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting UserTokenType failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "TriggerKeyUpdate"), nodeId)) {
            this.t(serviceContext);
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "ConnectSecurityGroups"), nodeId)) {
            return new Variant[]{new Variant(this.a(serviceContext, (NodeId[])variantArray[0].getValue()))};
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "DisconnectSecurityGroups"), nodeId)) {
            return new Variant[]{new Variant(this.b(serviceContext, (NodeId[])variantArray[0].getValue()))};
        }
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    @Mandatory
    public UaMethod getTriggerKeyUpdateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TriggerKeyUpdate");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onTriggerKeyUpdate(ServiceContext var1) throws StatusException;

    @Override
    public void triggerKeyUpdate() throws StatusException {
        this.t(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    private void t(ServiceContext serviceContext) throws StatusException {
        PubSubKeyPushTargetTypeTriggerKeyUpdateMethod pubSubKeyPushTargetTypeTriggerKeyUpdateMethod = PubSubKeyPushTargetTypeNodeBase.getTriggerKeyUpdateMethodImplementation();
        if (pubSubKeyPushTargetTypeTriggerKeyUpdateMethod != null) {
            pubSubKeyPushTargetTypeTriggerKeyUpdateMethod.triggerKeyUpdate(serviceContext, (PubSubKeyPushTargetTypeNode)this);
        } else {
            this.onTriggerKeyUpdate(serviceContext);
        }
    }

    public static PubSubKeyPushTargetTypeTriggerKeyUpdateMethod getTriggerKeyUpdateMethodImplementation() {
        return LH;
    }

    public static void setTriggerKeyUpdateMethodImplementation(PubSubKeyPushTargetTypeTriggerKeyUpdateMethod pubSubKeyPushTargetTypeTriggerKeyUpdateMethod) {
        LH = pubSubKeyPushTargetTypeTriggerKeyUpdateMethod;
    }

    @Override
    @Mandatory
    public UaMethod getConnectSecurityGroupsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ConnectSecurityGroups");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract StatusCode[] onConnectSecurityGroups(ServiceContext var1, NodeId[] var2) throws StatusException;

    @Override
    public StatusCode[] connectSecurityGroups(NodeId[] nodeIdArray) throws StatusException {
        return this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, nodeIdArray);
    }

    private StatusCode[] a(ServiceContext serviceContext, NodeId[] nodeIdArray) throws StatusException {
        PubSubKeyPushTargetTypeConnectSecurityGroupsMethod pubSubKeyPushTargetTypeConnectSecurityGroupsMethod = PubSubKeyPushTargetTypeNodeBase.getConnectSecurityGroupsMethodImplementation();
        if (pubSubKeyPushTargetTypeConnectSecurityGroupsMethod != null) {
            return pubSubKeyPushTargetTypeConnectSecurityGroupsMethod.connectSecurityGroups(serviceContext, (PubSubKeyPushTargetTypeNode)this, nodeIdArray);
        }
        return this.onConnectSecurityGroups(serviceContext, nodeIdArray);
    }

    public static PubSubKeyPushTargetTypeConnectSecurityGroupsMethod getConnectSecurityGroupsMethodImplementation() {
        return LI;
    }

    public static void setConnectSecurityGroupsMethodImplementation(PubSubKeyPushTargetTypeConnectSecurityGroupsMethod pubSubKeyPushTargetTypeConnectSecurityGroupsMethod) {
        LI = pubSubKeyPushTargetTypeConnectSecurityGroupsMethod;
    }

    @Override
    @Mandatory
    public UaMethod getDisconnectSecurityGroupsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DisconnectSecurityGroups");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract StatusCode[] onDisconnectSecurityGroups(ServiceContext var1, NodeId[] var2) throws StatusException;

    @Override
    public StatusCode[] disconnectSecurityGroups(NodeId[] nodeIdArray) throws StatusException {
        return this.b(ServiceContext.INTERNAL_OPERATION_CONTEXT, nodeIdArray);
    }

    private StatusCode[] b(ServiceContext serviceContext, NodeId[] nodeIdArray) throws StatusException {
        PubSubKeyPushTargetTypeDisconnectSecurityGroupsMethod pubSubKeyPushTargetTypeDisconnectSecurityGroupsMethod = PubSubKeyPushTargetTypeNodeBase.getDisconnectSecurityGroupsMethodImplementation();
        if (pubSubKeyPushTargetTypeDisconnectSecurityGroupsMethod != null) {
            return pubSubKeyPushTargetTypeDisconnectSecurityGroupsMethod.disconnectSecurityGroups(serviceContext, (PubSubKeyPushTargetTypeNode)this, nodeIdArray);
        }
        return this.onDisconnectSecurityGroups(serviceContext, nodeIdArray);
    }

    public static PubSubKeyPushTargetTypeDisconnectSecurityGroupsMethod getDisconnectSecurityGroupsMethodImplementation() {
        return LJ;
    }

    public static void setDisconnectSecurityGroupsMethodImplementation(PubSubKeyPushTargetTypeDisconnectSecurityGroupsMethod pubSubKeyPushTargetTypeDisconnectSecurityGroupsMethod) {
        LJ = pubSubKeyPushTargetTypeDisconnectSecurityGroupsMethod;
    }
}

