/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.EndpointDescription;
import com.prosysopc.ua.stack.core.KeyValuePair;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.types.opcua.PubSubGroupType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.PubSubGroupTypeNode;
import com.prosysopc.ua.types.opcua.server.PubSubStatusTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=14232")
public abstract class PubSubGroupTypeNodeBase
extends BaseObjectTypeNode
implements PubSubGroupType {
    private static GeneratedNodeInitializer<PubSubGroupTypeNode> LA;

    protected PubSubGroupTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getStatusNode());
        GeneratedNodeInitializer<PubSubGroupTypeNode> generatedNodeInitializer = PubSubGroupTypeNodeBase.getPubSubGroupTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((PubSubGroupTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<PubSubGroupTypeNode> getPubSubGroupTypeNodeInitializer() {
        return LA;
    }

    public static void setPubSubGroupTypeNodeInitializer(GeneratedNodeInitializer<PubSubGroupTypeNode> generatedNodeInitializer) {
        LA = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getSecurityModeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SecurityMode");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public MessageSecurityMode getSecurityMode() {
        UaProperty uaProperty = this.getSecurityModeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node SecurityMode does not exist");
        }
        Variant variant = uaProperty.getValue().getValue();
        return (MessageSecurityMode)variant.asEnum(MessageSecurityMode.class);
    }

    @Override
    @Mandatory
    public void setSecurityMode(MessageSecurityMode messageSecurityMode) {
        UaProperty uaProperty = this.getSecurityModeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SecurityMode failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(messageSecurityMode);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SecurityMode failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getSecurityGroupIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SecurityGroupId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getSecurityGroupId() {
        UaProperty uaProperty = this.getSecurityGroupIdNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setSecurityGroupId(String string) {
        UaProperty uaProperty = this.getSecurityGroupIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SecurityGroupId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SecurityGroupId failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getSecurityKeyServicesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SecurityKeyServices");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public EndpointDescription[] getSecurityKeyServices() {
        UaProperty uaProperty = this.getSecurityKeyServicesNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (EndpointDescription[])object;
    }

    @Override
    @Optional
    public void setSecurityKeyServices(EndpointDescription[] endpointDescriptionArray) {
        UaProperty uaProperty = this.getSecurityKeyServicesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SecurityKeyServices failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(endpointDescriptionArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SecurityKeyServices failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getMaxNetworkMessageSizeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxNetworkMessageSize");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getMaxNetworkMessageSize() {
        UaProperty uaProperty = this.getMaxNetworkMessageSizeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node MaxNetworkMessageSize does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setMaxNetworkMessageSize(UnsignedInteger unsignedInteger) {
        UaProperty uaProperty = this.getMaxNetworkMessageSizeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxNetworkMessageSize failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MaxNetworkMessageSize failed unexpectedly", statusException);
        }
    }

    public void setMaxNetworkMessageSize(long l2) {
        this.setMaxNetworkMessageSize(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public UaProperty getGroupPropertiesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "GroupProperties");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public KeyValuePair[] getGroupProperties() {
        UaProperty uaProperty = this.getGroupPropertiesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node GroupProperties does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (KeyValuePair[])object;
    }

    @Override
    @Mandatory
    public void setGroupProperties(KeyValuePair[] keyValuePairArray) {
        UaProperty uaProperty = this.getGroupPropertiesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting GroupProperties failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(keyValuePairArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting GroupProperties failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public PubSubStatusTypeNode getStatusNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Status");
        return (PubSubStatusTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

