/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.DiagnosticsLevel;
import com.prosysopc.ua.stack.core.PubSubDiagnosticsCounterClassification;
import com.prosysopc.ua.types.opcua.PubSubDiagnosticsCounterType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.PubSubDiagnosticsCounterTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=19725")
public abstract class PubSubDiagnosticsCounterTypeNodeBase
extends BaseDataVariableTypeNode
implements PubSubDiagnosticsCounterType {
    private static GeneratedNodeInitializer<PubSubDiagnosticsCounterTypeNode> Ls;

    protected PubSubDiagnosticsCounterTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<PubSubDiagnosticsCounterTypeNode> generatedNodeInitializer = PubSubDiagnosticsCounterTypeNodeBase.getPubSubDiagnosticsCounterTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((PubSubDiagnosticsCounterTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<PubSubDiagnosticsCounterTypeNode> getPubSubDiagnosticsCounterTypeNodeInitializer() {
        return Ls;
    }

    public static void setPubSubDiagnosticsCounterTypeNodeInitializer(GeneratedNodeInitializer<PubSubDiagnosticsCounterTypeNode> generatedNodeInitializer) {
        Ls = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getActiveNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Active");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isActive() {
        UaProperty uaProperty = this.getActiveNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node Active does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setActive(Boolean bl) {
        UaProperty uaProperty = this.getActiveNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Active failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(bl);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Active failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getTimeFirstChangeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TimeFirstChange");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public DateTime getTimeFirstChange() {
        UaProperty uaProperty = this.getTimeFirstChangeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Optional
    public void setTimeFirstChange(DateTime dateTime) {
        UaProperty uaProperty = this.getTimeFirstChangeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting TimeFirstChange failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(dateTime);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting TimeFirstChange failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getDiagnosticsLevelNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DiagnosticsLevel");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DiagnosticsLevel getDiagnosticsLevel() {
        UaProperty uaProperty = this.getDiagnosticsLevelNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node DiagnosticsLevel does not exist");
        }
        Variant variant = uaProperty.getValue().getValue();
        return (DiagnosticsLevel)variant.asEnum(DiagnosticsLevel.class);
    }

    @Override
    @Mandatory
    public void setDiagnosticsLevel(DiagnosticsLevel diagnosticsLevel) {
        UaProperty uaProperty = this.getDiagnosticsLevelNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DiagnosticsLevel failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(diagnosticsLevel);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DiagnosticsLevel failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getClassificationNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Classification");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public PubSubDiagnosticsCounterClassification getClassification() {
        UaProperty uaProperty = this.getClassificationNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node Classification does not exist");
        }
        Variant variant = uaProperty.getValue().getValue();
        return (PubSubDiagnosticsCounterClassification)variant.asEnum(PubSubDiagnosticsCounterClassification.class);
    }

    @Override
    @Mandatory
    public void setClassification(PubSubDiagnosticsCounterClassification pubSubDiagnosticsCounterClassification) {
        UaProperty uaProperty = this.getClassificationNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Classification failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(pubSubDiagnosticsCounterClassification);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Classification failed unexpectedly", statusException);
        }
    }
}

