/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.ProgressEventType;
import com.prosysopc.ua.types.opcua.server.BaseEventTypeNode;
import com.prosysopc.ua.types.opcua.server.ProgressEventTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=11436")
public abstract class ProgressEventTypeNodeBase
extends BaseEventTypeNode
implements ProgressEventType {
    private static GeneratedNodeInitializer<ProgressEventTypeNode> Ld;

    protected ProgressEventTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<ProgressEventTypeNode> generatedNodeInitializer = ProgressEventTypeNodeBase.getProgressEventTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((ProgressEventTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<ProgressEventTypeNode> getProgressEventTypeNodeInitializer() {
        return Ld;
    }

    public static void setProgressEventTypeNodeInitializer(GeneratedNodeInitializer<ProgressEventTypeNode> generatedNodeInitializer) {
        Ld = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getContextNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Context");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Object getContext() {
        UaProperty uaProperty = this.getContextNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node Context does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return object;
    }

    @Override
    @Mandatory
    public void setContext(Object object) {
        UaProperty uaProperty = this.getContextNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Context failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(object);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Context failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getProgressNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Progress");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getProgress() {
        UaProperty uaProperty = this.getProgressNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node Progress does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setProgress(UnsignedShort unsignedShort) {
        UaProperty uaProperty = this.getProgressNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Progress failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedShort);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Progress failed unexpectedly", statusException);
        }
    }

    public void setProgress(int n2) {
        this.setProgress(UnsignedShort.valueOf(n2));
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

