/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.NetworkAddressType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.NetworkAddressTypeNode;
import com.prosysopc.ua.types.opcua.server.SelectionListTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=21145")
public abstract class NetworkAddressTypeNodeBase
extends BaseObjectTypeNode
implements NetworkAddressType {
    private static GeneratedNodeInitializer<NetworkAddressTypeNode> KA;

    protected NetworkAddressTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getNetworkInterfaceNode());
        GeneratedNodeInitializer<NetworkAddressTypeNode> generatedNodeInitializer = NetworkAddressTypeNodeBase.getNetworkAddressTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((NetworkAddressTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<NetworkAddressTypeNode> getNetworkAddressTypeNodeInitializer() {
        return KA;
    }

    public static void setNetworkAddressTypeNodeInitializer(GeneratedNodeInitializer<NetworkAddressTypeNode> generatedNodeInitializer) {
        KA = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public SelectionListTypeNode getNetworkInterfaceNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "NetworkInterface");
        return (SelectionListTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getNetworkInterface() {
        SelectionListTypeNode selectionListTypeNode = this.getNetworkInterfaceNode();
        if (selectionListTypeNode == null) {
            throw new RuntimeException("Mandatory node NetworkInterface does not exist");
        }
        Object object = selectionListTypeNode.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setNetworkInterface(String string) {
        SelectionListTypeNode selectionListTypeNode = this.getNetworkInterfaceNode();
        if (selectionListTypeNode == null) {
            throw new RuntimeException("Setting NetworkInterface failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            selectionListTypeNode.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting NetworkInterface failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

