/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.core.EnumValueType;
import com.prosysopc.ua.types.opcua.MultiStateValueDiscreteType;
import com.prosysopc.ua.types.opcua.server.DiscreteItemTypeNode;
import com.prosysopc.ua.types.opcua.server.MultiStateValueDiscreteTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=11238")
public abstract class MultiStateValueDiscreteTypeNodeBase
extends DiscreteItemTypeNode
implements MultiStateValueDiscreteType {
    private static GeneratedNodeInitializer<MultiStateValueDiscreteTypeNode> Kw;

    protected MultiStateValueDiscreteTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<MultiStateValueDiscreteTypeNode> generatedNodeInitializer = MultiStateValueDiscreteTypeNodeBase.getMultiStateValueDiscreteTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((MultiStateValueDiscreteTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<MultiStateValueDiscreteTypeNode> getMultiStateValueDiscreteTypeNodeInitializer() {
        return Kw;
    }

    public static void setMultiStateValueDiscreteTypeNodeInitializer(GeneratedNodeInitializer<MultiStateValueDiscreteTypeNode> generatedNodeInitializer) {
        Kw = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getEnumValuesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EnumValues");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public EnumValueType[] getEnumValues() {
        UaProperty uaProperty = this.getEnumValuesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node EnumValues does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (EnumValueType[])object;
    }

    @Override
    @Mandatory
    public void setEnumValues(EnumValueType[] enumValueTypeArray) {
        UaProperty uaProperty = this.getEnumValuesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EnumValues failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(enumValueTypeArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting EnumValues failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getValueAsTextNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ValueAsText");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getValueAsText() {
        UaProperty uaProperty = this.getValueAsTextNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ValueAsText does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setValueAsText(LocalizedText localizedText) {
        UaProperty uaProperty = this.getValueAsTextNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ValueAsText failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(localizedText);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ValueAsText failed unexpectedly", statusException);
        }
    }
}

