/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.JsonDataSetMessageContentMask;
import com.prosysopc.ua.stack.core.JsonNetworkMessageContentMask;
import com.prosysopc.ua.types.opcua.JsonDataSetReaderMessageType;
import com.prosysopc.ua.types.opcua.server.DataSetReaderMessageTypeNode;
import com.prosysopc.ua.types.opcua.server.JsonDataSetReaderMessageTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=21130")
public abstract class JsonDataSetReaderMessageTypeNodeBase
extends DataSetReaderMessageTypeNode
implements JsonDataSetReaderMessageType {
    private static GeneratedNodeInitializer<JsonDataSetReaderMessageTypeNode> Ke;

    protected JsonDataSetReaderMessageTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<JsonDataSetReaderMessageTypeNode> generatedNodeInitializer = JsonDataSetReaderMessageTypeNodeBase.getJsonDataSetReaderMessageTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((JsonDataSetReaderMessageTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<JsonDataSetReaderMessageTypeNode> getJsonDataSetReaderMessageTypeNodeInitializer() {
        return Ke;
    }

    public static void setJsonDataSetReaderMessageTypeNodeInitializer(GeneratedNodeInitializer<JsonDataSetReaderMessageTypeNode> generatedNodeInitializer) {
        Ke = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getDataSetMessageContentMaskNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DataSetMessageContentMask");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public JsonDataSetMessageContentMask getDataSetMessageContentMask() {
        UaProperty uaProperty = this.getDataSetMessageContentMaskNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node DataSetMessageContentMask does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (JsonDataSetMessageContentMask)object;
    }

    @Override
    @Mandatory
    public void setDataSetMessageContentMask(JsonDataSetMessageContentMask jsonDataSetMessageContentMask) {
        UaProperty uaProperty = this.getDataSetMessageContentMaskNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DataSetMessageContentMask failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(jsonDataSetMessageContentMask);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DataSetMessageContentMask failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getNetworkMessageContentMaskNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "NetworkMessageContentMask");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public JsonNetworkMessageContentMask getNetworkMessageContentMask() {
        UaProperty uaProperty = this.getNetworkMessageContentMaskNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node NetworkMessageContentMask does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (JsonNetworkMessageContentMask)object;
    }

    @Override
    @Mandatory
    public void setNetworkMessageContentMask(JsonNetworkMessageContentMask jsonNetworkMessageContentMask) {
        UaProperty uaProperty = this.getNetworkMessageContentMaskNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting NetworkMessageContentMask failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(jsonNetworkMessageContentMask);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting NetworkMessageContentMask failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

