/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.ISrClassType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.BaseInterfaceTypeNode;
import com.prosysopc.ua.types.opcua.server.ISrClassTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=24169")
public abstract class ISrClassTypeNodeBase
extends BaseInterfaceTypeNode
implements ISrClassType {
    private static GeneratedNodeInitializer<ISrClassTypeNode> JX;

    protected ISrClassTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getVidNode());
        this.callAfterCreateIfExists(this.getIdNode());
        this.callAfterCreateIfExists(this.getPriorityNode());
        GeneratedNodeInitializer<ISrClassTypeNode> generatedNodeInitializer = ISrClassTypeNodeBase.getISrClassTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((ISrClassTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<ISrClassTypeNode> getISrClassTypeNodeInitializer() {
        return JX;
    }

    public static void setISrClassTypeNodeInitializer(GeneratedNodeInitializer<ISrClassTypeNode> generatedNodeInitializer) {
        JX = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getVidNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Vid");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getVid() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getVidNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node Vid does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setVid(UnsignedShort unsignedShort) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getVidNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting Vid failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedShort);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Vid failed unexpectedly", statusException);
        }
    }

    public void setVid(int n2) {
        this.setVid(UnsignedShort.valueOf(n2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Id");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedByte getId() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getIdNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node Id does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedByte)object;
    }

    @Override
    @Mandatory
    public void setId(UnsignedByte unsignedByte) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getIdNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting Id failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedByte);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Id failed unexpectedly", statusException);
        }
    }

    public void setId(int n2) {
        this.setId(UnsignedByte.valueOf(n2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getPriorityNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Priority");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedByte getPriority() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getPriorityNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node Priority does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedByte)object;
    }

    @Override
    @Mandatory
    public void setPriority(UnsignedByte unsignedByte) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getPriorityNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting Priority failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedByte);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Priority failed unexpectedly", statusException);
        }
    }

    public void setPriority(int n2) {
        this.setPriority(UnsignedByte.valueOf(n2));
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

