/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.IIeeeTsnMacAddressType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.BaseInterfaceTypeNode;
import com.prosysopc.ua.types.opcua.server.IIeeeTsnMacAddressTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=24199")
public abstract class IIeeeTsnMacAddressTypeNodeBase
extends BaseInterfaceTypeNode
implements IIeeeTsnMacAddressType {
    private static GeneratedNodeInitializer<IIeeeTsnMacAddressTypeNode> JS;

    protected IIeeeTsnMacAddressTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getSourceAddressNode());
        this.callAfterCreateIfExists(this.getDestinationAddressNode());
        GeneratedNodeInitializer<IIeeeTsnMacAddressTypeNode> generatedNodeInitializer = IIeeeTsnMacAddressTypeNodeBase.getIIeeeTsnMacAddressTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((IIeeeTsnMacAddressTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<IIeeeTsnMacAddressTypeNode> getIIeeeTsnMacAddressTypeNodeInitializer() {
        return JS;
    }

    public static void setIIeeeTsnMacAddressTypeNodeInitializer(GeneratedNodeInitializer<IIeeeTsnMacAddressTypeNode> generatedNodeInitializer) {
        JS = generatedNodeInitializer;
    }

    @Override
    @Optional
    public BaseDataVariableTypeNode getSourceAddressNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SourceAddress");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedByte[] getSourceAddress() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSourceAddressNode();
        if (baseDataVariableTypeNode == null) {
            return null;
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedByte[])object;
    }

    @Override
    @Optional
    public void setSourceAddress(UnsignedByte[] unsignedByteArray) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSourceAddressNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting SourceAddress failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedByteArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SourceAddress failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getDestinationAddressNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DestinationAddress");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedByte[] getDestinationAddress() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getDestinationAddressNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node DestinationAddress does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedByte[])object;
    }

    @Override
    @Mandatory
    public void setDestinationAddress(UnsignedByte[] unsignedByteArray) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getDestinationAddressNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting DestinationAddress failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedByteArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DestinationAddress failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

