/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedLong;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.Duplex;
import com.prosysopc.ua.types.opcua.IIeeeBaseEthernetPortType;
import com.prosysopc.ua.types.opcua.server.AnalogUnitTypeNode;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.BaseInterfaceTypeNode;
import com.prosysopc.ua.types.opcua.server.IIeeeBaseEthernetPortTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=24158")
public abstract class IIeeeBaseEthernetPortTypeNodeBase
extends BaseInterfaceTypeNode
implements IIeeeBaseEthernetPortType {
    private static GeneratedNodeInitializer<IIeeeBaseEthernetPortTypeNode> JL;

    protected IIeeeBaseEthernetPortTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getMaxFrameLengthNode());
        this.callAfterCreateIfExists(this.getSpeedNode());
        this.callAfterCreateIfExists(this.getDuplexNode());
        GeneratedNodeInitializer<IIeeeBaseEthernetPortTypeNode> generatedNodeInitializer = IIeeeBaseEthernetPortTypeNodeBase.getIIeeeBaseEthernetPortTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((IIeeeBaseEthernetPortTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<IIeeeBaseEthernetPortTypeNode> getIIeeeBaseEthernetPortTypeNodeInitializer() {
        return JL;
    }

    public static void setIIeeeBaseEthernetPortTypeNodeInitializer(GeneratedNodeInitializer<IIeeeBaseEthernetPortTypeNode> generatedNodeInitializer) {
        JL = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getMaxFrameLengthNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxFrameLength");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getMaxFrameLength() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getMaxFrameLengthNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node MaxFrameLength does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setMaxFrameLength(UnsignedShort unsignedShort) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getMaxFrameLengthNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting MaxFrameLength failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedShort);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MaxFrameLength failed unexpectedly", statusException);
        }
    }

    public void setMaxFrameLength(int n2) {
        this.setMaxFrameLength(UnsignedShort.valueOf(n2));
    }

    @Override
    @Mandatory
    public AnalogUnitTypeNode getSpeedNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Speed");
        return (AnalogUnitTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedLong getSpeed() {
        AnalogUnitTypeNode analogUnitTypeNode = this.getSpeedNode();
        if (analogUnitTypeNode == null) {
            throw new RuntimeException("Mandatory node Speed does not exist");
        }
        Object object = analogUnitTypeNode.getValue().getValue().getValue();
        return (UnsignedLong)object;
    }

    @Override
    @Mandatory
    public void setSpeed(UnsignedLong unsignedLong) {
        AnalogUnitTypeNode analogUnitTypeNode = this.getSpeedNode();
        if (analogUnitTypeNode == null) {
            throw new RuntimeException("Setting Speed failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            analogUnitTypeNode.setValue(unsignedLong);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Speed failed unexpectedly", statusException);
        }
    }

    public void setSpeed(long l2) {
        this.setSpeed(UnsignedLong.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getDuplexNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Duplex");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public Duplex getDuplex() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getDuplexNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node Duplex does not exist");
        }
        Variant variant = baseDataVariableTypeNode.getValue().getValue();
        return (Duplex)variant.asEnum(Duplex.class);
    }

    @Override
    @Mandatory
    public void setDuplex(Duplex duplex) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getDuplexNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting Duplex failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(duplex);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Duplex failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

