/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.EventFilter;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.core.UserTokenPolicy;
import com.prosysopc.ua.types.opcua.HistoricalExternalEventSourceType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.HistoricalExternalEventSourceTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=32625")
public abstract class HistoricalExternalEventSourceTypeNodeBase
extends BaseObjectTypeNode
implements HistoricalExternalEventSourceType {
    private static GeneratedNodeInitializer<HistoricalExternalEventSourceTypeNode> JG;

    protected HistoricalExternalEventSourceTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<HistoricalExternalEventSourceTypeNode> generatedNodeInitializer = HistoricalExternalEventSourceTypeNodeBase.getHistoricalExternalEventSourceTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((HistoricalExternalEventSourceTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<HistoricalExternalEventSourceTypeNode> getHistoricalExternalEventSourceTypeNodeInitializer() {
        return JG;
    }

    public static void setHistoricalExternalEventSourceTypeNodeInitializer(GeneratedNodeInitializer<HistoricalExternalEventSourceTypeNode> generatedNodeInitializer) {
        JG = generatedNodeInitializer;
    }

    @Override
    @Optional
    public UaProperty getServerNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Server");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getServer() {
        UaProperty uaProperty = this.getServerNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setServer(String string) {
        UaProperty uaProperty = this.getServerNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Server failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Server failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getIdentityTokenPolicyNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "IdentityTokenPolicy");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UserTokenPolicy getIdentityTokenPolicy() {
        UaProperty uaProperty = this.getIdentityTokenPolicyNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UserTokenPolicy)object;
    }

    @Override
    @Optional
    public void setIdentityTokenPolicy(UserTokenPolicy userTokenPolicy) {
        UaProperty uaProperty = this.getIdentityTokenPolicyNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting IdentityTokenPolicy failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(userTokenPolicy);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting IdentityTokenPolicy failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getEndpointUrlNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EndpointUrl");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getEndpointUrl() {
        UaProperty uaProperty = this.getEndpointUrlNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setEndpointUrl(String string) {
        UaProperty uaProperty = this.getEndpointUrlNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EndpointUrl failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting EndpointUrl failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getSecurityModeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SecurityMode");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public MessageSecurityMode getSecurityMode() {
        UaProperty uaProperty = this.getSecurityModeNode();
        if (uaProperty == null) {
            return null;
        }
        Variant variant = uaProperty.getValue().getValue();
        return (MessageSecurityMode)variant.asEnum(MessageSecurityMode.class);
    }

    @Override
    @Optional
    public void setSecurityMode(MessageSecurityMode messageSecurityMode) {
        UaProperty uaProperty = this.getSecurityModeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SecurityMode failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(messageSecurityMode);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SecurityMode failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getHistoricalEventFilterNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "HistoricalEventFilter");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public EventFilter getHistoricalEventFilter() {
        UaProperty uaProperty = this.getHistoricalEventFilterNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node HistoricalEventFilter does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (EventFilter)object;
    }

    @Override
    @Mandatory
    public void setHistoricalEventFilter(EventFilter eventFilter) {
        UaProperty uaProperty = this.getHistoricalEventFilterNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting HistoricalEventFilter failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(eventFilter);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting HistoricalEventFilter failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getSecurityPolicyUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SecurityPolicyUri");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getSecurityPolicyUri() {
        UaProperty uaProperty = this.getSecurityPolicyUriNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setSecurityPolicyUri(String string) {
        UaProperty uaProperty = this.getSecurityPolicyUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SecurityPolicyUri failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SecurityPolicyUri failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getTransportProfileUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TransportProfileUri");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getTransportProfileUri() {
        UaProperty uaProperty = this.getTransportProfileUriNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setTransportProfileUri(String string) {
        UaProperty uaProperty = this.getTransportProfileUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting TransportProfileUri failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting TransportProfileUri failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

