/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.ExclusiveDeviationAlarmType;
import com.prosysopc.ua.types.opcua.server.ExclusiveDeviationAlarmTypeNode;
import com.prosysopc.ua.types.opcua.server.ExclusiveLimitAlarmTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=9764")
public abstract class ExclusiveDeviationAlarmTypeNodeBase
extends ExclusiveLimitAlarmTypeNode
implements ExclusiveDeviationAlarmType {
    private static GeneratedNodeInitializer<ExclusiveDeviationAlarmTypeNode> IS;

    protected ExclusiveDeviationAlarmTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<ExclusiveDeviationAlarmTypeNode> generatedNodeInitializer = ExclusiveDeviationAlarmTypeNodeBase.getExclusiveDeviationAlarmTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((ExclusiveDeviationAlarmTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<ExclusiveDeviationAlarmTypeNode> getExclusiveDeviationAlarmTypeNodeInitializer() {
        return IS;
    }

    public static void setExclusiveDeviationAlarmTypeNodeInitializer(GeneratedNodeInitializer<ExclusiveDeviationAlarmTypeNode> generatedNodeInitializer) {
        IS = generatedNodeInitializer;
    }

    @Override
    @Optional
    public UaProperty getBaseSetpointNodeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "BaseSetpointNode");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public NodeId getBaseSetpointNode() {
        UaProperty uaProperty = this.getBaseSetpointNodeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Optional
    public void setBaseSetpointNode(NodeId nodeId) {
        UaProperty uaProperty = this.getBaseSetpointNodeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting BaseSetpointNode failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(nodeId);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting BaseSetpointNode failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getSetpointNodeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SetpointNode");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getSetpointNode() {
        UaProperty uaProperty = this.getSetpointNodeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node SetpointNode does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setSetpointNode(NodeId nodeId) {
        UaProperty uaProperty = this.getSetpointNodeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SetpointNode failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(nodeId);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SetpointNode failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

