/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.ReceiveQosDataType;
import com.prosysopc.ua.types.opcua.DatagramDataSetReaderTransportType;
import com.prosysopc.ua.types.opcua.server.DataSetReaderTransportTypeNode;
import com.prosysopc.ua.types.opcua.server.DatagramDataSetReaderTransportTypeNode;
import com.prosysopc.ua.types.opcua.server.NetworkAddressTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=24016")
public abstract class DatagramDataSetReaderTransportTypeNodeBase
extends DataSetReaderTransportTypeNode
implements DatagramDataSetReaderTransportType {
    private static GeneratedNodeInitializer<DatagramDataSetReaderTransportTypeNode> Iw;

    protected DatagramDataSetReaderTransportTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getAddressNode());
        GeneratedNodeInitializer<DatagramDataSetReaderTransportTypeNode> generatedNodeInitializer = DatagramDataSetReaderTransportTypeNodeBase.getDatagramDataSetReaderTransportTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((DatagramDataSetReaderTransportTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<DatagramDataSetReaderTransportTypeNode> getDatagramDataSetReaderTransportTypeNodeInitializer() {
        return Iw;
    }

    public static void setDatagramDataSetReaderTransportTypeNodeInitializer(GeneratedNodeInitializer<DatagramDataSetReaderTransportTypeNode> generatedNodeInitializer) {
        Iw = generatedNodeInitializer;
    }

    @Override
    @Optional
    public UaProperty getTopicNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Topic");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getTopic() {
        UaProperty uaProperty = this.getTopicNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setTopic(String string) {
        UaProperty uaProperty = this.getTopicNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Topic failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Topic failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getQosCategoryNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "QosCategory");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getQosCategory() {
        UaProperty uaProperty = this.getQosCategoryNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setQosCategory(String string) {
        UaProperty uaProperty = this.getQosCategoryNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting QosCategory failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting QosCategory failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getDatagramQosNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DatagramQos");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public ReceiveQosDataType[] getDatagramQos() {
        UaProperty uaProperty = this.getDatagramQosNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (ReceiveQosDataType[])object;
    }

    @Override
    @Optional
    public void setDatagramQos(ReceiveQosDataType[] receiveQosDataTypeArray) {
        UaProperty uaProperty = this.getDatagramQosNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DatagramQos failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(receiveQosDataTypeArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DatagramQos failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public NetworkAddressTypeNode getAddressNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Address");
        return (NetworkAddressTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

