/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.QosDataType;
import com.prosysopc.ua.types.opcua.DatagramConnectionTransportType;
import com.prosysopc.ua.types.opcua.server.ConnectionTransportTypeNode;
import com.prosysopc.ua.types.opcua.server.DatagramConnectionTransportTypeNode;
import com.prosysopc.ua.types.opcua.server.NetworkAddressTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=15064")
public abstract class DatagramConnectionTransportTypeNodeBase
extends ConnectionTransportTypeNode
implements DatagramConnectionTransportType {
    private static GeneratedNodeInitializer<DatagramConnectionTransportTypeNode> Iv;

    protected DatagramConnectionTransportTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getDiscoveryAddressNode());
        GeneratedNodeInitializer<DatagramConnectionTransportTypeNode> generatedNodeInitializer = DatagramConnectionTransportTypeNodeBase.getDatagramConnectionTransportTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((DatagramConnectionTransportTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<DatagramConnectionTransportTypeNode> getDatagramConnectionTransportTypeNodeInitializer() {
        return Iv;
    }

    public static void setDatagramConnectionTransportTypeNodeInitializer(GeneratedNodeInitializer<DatagramConnectionTransportTypeNode> generatedNodeInitializer) {
        Iv = generatedNodeInitializer;
    }

    @Override
    @Optional
    public UaProperty getDiscoveryMaxMessageSizeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DiscoveryMaxMessageSize");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getDiscoveryMaxMessageSize() {
        UaProperty uaProperty = this.getDiscoveryMaxMessageSizeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setDiscoveryMaxMessageSize(UnsignedInteger unsignedInteger) {
        UaProperty uaProperty = this.getDiscoveryMaxMessageSizeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DiscoveryMaxMessageSize failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DiscoveryMaxMessageSize failed unexpectedly", statusException);
        }
    }

    public void setDiscoveryMaxMessageSize(long l2) {
        this.setDiscoveryMaxMessageSize(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Optional
    public UaProperty getDiscoveryAnnounceRateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DiscoveryAnnounceRate");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getDiscoveryAnnounceRate() {
        UaProperty uaProperty = this.getDiscoveryAnnounceRateNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setDiscoveryAnnounceRate(UnsignedInteger unsignedInteger) {
        UaProperty uaProperty = this.getDiscoveryAnnounceRateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DiscoveryAnnounceRate failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DiscoveryAnnounceRate failed unexpectedly", statusException);
        }
    }

    public void setDiscoveryAnnounceRate(long l2) {
        this.setDiscoveryAnnounceRate(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Optional
    public UaProperty getQosCategoryNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "QosCategory");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getQosCategory() {
        UaProperty uaProperty = this.getQosCategoryNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setQosCategory(String string) {
        UaProperty uaProperty = this.getQosCategoryNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting QosCategory failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting QosCategory failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getDatagramQosNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DatagramQos");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public QosDataType[] getDatagramQos() {
        UaProperty uaProperty = this.getDatagramQosNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (QosDataType[])object;
    }

    @Override
    @Optional
    public void setDatagramQos(QosDataType[] qosDataTypeArray) {
        UaProperty uaProperty = this.getDatagramQosNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DatagramQos failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(qosDataTypeArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DatagramQos failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public NetworkAddressTypeNode getDiscoveryAddressNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DiscoveryAddress");
        return (NetworkAddressTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

