/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.core.AxisInformation;
import com.prosysopc.ua.types.opcua.CubeItemType;
import com.prosysopc.ua.types.opcua.server.ArrayItemTypeNode;
import com.prosysopc.ua.types.opcua.server.CubeItemTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=12057")
public abstract class CubeItemTypeNodeBase
extends ArrayItemTypeNode
implements CubeItemType {
    private static GeneratedNodeInitializer<CubeItemTypeNode> HY;

    protected CubeItemTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<CubeItemTypeNode> generatedNodeInitializer = CubeItemTypeNodeBase.getCubeItemTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((CubeItemTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<CubeItemTypeNode> getCubeItemTypeNodeInitializer() {
        return HY;
    }

    public static void setCubeItemTypeNodeInitializer(GeneratedNodeInitializer<CubeItemTypeNode> generatedNodeInitializer) {
        HY = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getYAxisDefinitionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "YAxisDefinition");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public AxisInformation getYAxisDefinition() {
        UaProperty uaProperty = this.getYAxisDefinitionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node YAxisDefinition does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (AxisInformation)object;
    }

    @Override
    @Mandatory
    public void setYAxisDefinition(AxisInformation axisInformation) {
        UaProperty uaProperty = this.getYAxisDefinitionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting YAxisDefinition failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(axisInformation);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting YAxisDefinition failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getZAxisDefinitionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ZAxisDefinition");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public AxisInformation getZAxisDefinition() {
        UaProperty uaProperty = this.getZAxisDefinitionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ZAxisDefinition does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (AxisInformation)object;
    }

    @Override
    @Mandatory
    public void setZAxisDefinition(AxisInformation axisInformation) {
        UaProperty uaProperty = this.getZAxisDefinitionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ZAxisDefinition failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(axisInformation);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ZAxisDefinition failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getXAxisDefinitionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "XAxisDefinition");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public AxisInformation getXAxisDefinition() {
        UaProperty uaProperty = this.getXAxisDefinitionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node XAxisDefinition does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (AxisInformation)object;
    }

    @Override
    @Mandatory
    public void setXAxisDefinition(AxisInformation axisInformation) {
        UaProperty uaProperty = this.getXAxisDefinitionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting XAxisDefinition failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(axisInformation);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting XAxisDefinition failed unexpectedly", statusException);
        }
    }
}

