/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.CertificateExpirationAlarmType;
import com.prosysopc.ua.types.opcua.server.CertificateExpirationAlarmTypeNode;
import com.prosysopc.ua.types.opcua.server.SystemOffNormalAlarmTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=13225")
public abstract class CertificateExpirationAlarmTypeNodeBase
extends SystemOffNormalAlarmTypeNode
implements CertificateExpirationAlarmType {
    private static GeneratedNodeInitializer<CertificateExpirationAlarmTypeNode> HK;

    protected CertificateExpirationAlarmTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<CertificateExpirationAlarmTypeNode> generatedNodeInitializer = CertificateExpirationAlarmTypeNodeBase.getCertificateExpirationAlarmTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((CertificateExpirationAlarmTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<CertificateExpirationAlarmTypeNode> getCertificateExpirationAlarmTypeNodeInitializer() {
        return HK;
    }

    public static void setCertificateExpirationAlarmTypeNodeInitializer(GeneratedNodeInitializer<CertificateExpirationAlarmTypeNode> generatedNodeInitializer) {
        HK = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getCertificateTypeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CertificateType");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getCertificateType() {
        UaProperty uaProperty = this.getCertificateTypeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node CertificateType does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setCertificateType(NodeId nodeId) {
        UaProperty uaProperty = this.getCertificateTypeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting CertificateType failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(nodeId);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting CertificateType failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getExpirationLimitNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ExpirationLimit");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Double getExpirationLimit() {
        UaProperty uaProperty = this.getExpirationLimitNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Optional
    public void setExpirationLimit(Double d2) {
        UaProperty uaProperty = this.getExpirationLimitNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ExpirationLimit failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ExpirationLimit failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getExpirationDateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ExpirationDate");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getExpirationDate() {
        UaProperty uaProperty = this.getExpirationDateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ExpirationDate does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setExpirationDate(DateTime dateTime) {
        UaProperty uaProperty = this.getExpirationDateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ExpirationDate failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(dateTime);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ExpirationDate failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getCertificateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Certificate");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public ByteString getCertificate() {
        UaProperty uaProperty = this.getCertificateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node Certificate does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (ByteString)object;
    }

    @Override
    @Mandatory
    public void setCertificate(ByteString byteString) {
        UaProperty uaProperty = this.getCertificateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Certificate failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(byteString);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Certificate failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

