/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.core.BitFieldDefinition;
import com.prosysopc.ua.types.opcua.BaseVariableType;
import com.prosysopc.ua.types.opcua.BitFieldType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.BitFieldTypeNode;
import java.util.List;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=32431")
public abstract class BitFieldTypeNodeBase
extends BaseDataVariableTypeNode
implements BitFieldType {
    private static GeneratedNodeInitializer<BitFieldTypeNode> HB;

    protected BitFieldTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<BitFieldTypeNode> generatedNodeInitializer = BitFieldTypeNodeBase.getBitFieldTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((BitFieldTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<BitFieldTypeNode> getBitFieldTypeNodeInitializer() {
        return HB;
    }

    public static void setBitFieldTypeNodeInitializer(GeneratedNodeInitializer<BitFieldTypeNode> generatedNodeInitializer) {
        HB = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getBitFieldsDefinitionsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "BitFieldsDefinitions");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public BitFieldDefinition[] getBitFieldsDefinitions() {
        UaProperty uaProperty = this.getBitFieldsDefinitionsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node BitFieldsDefinitions does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (BitFieldDefinition[])object;
    }

    @Override
    @Mandatory
    public void setBitFieldsDefinitions(BitFieldDefinition[] bitFieldDefinitionArray) {
        UaProperty uaProperty = this.getBitFieldsDefinitionsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting BitFieldsDefinitions failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(bitFieldDefinitionArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting BitFieldsDefinitions failed unexpectedly", statusException);
        }
    }

    @Override
    public List<? extends BaseVariableType> getFieldName_PlaceholderNodes() {
        ExpandedNodeId expandedNodeId = ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=32433");
        ExpandedNodeId expandedNodeId2 = ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=47");
        return this.findPlaceholders(BaseVariableType.class, expandedNodeId, expandedNodeId2);
    }

    @Override
    public List<? extends BaseVariableType> getOptionalFieldNamee_PlaceholderNodes() {
        ExpandedNodeId expandedNodeId = ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=15014");
        ExpandedNodeId expandedNodeId2 = ExpandedNodeId.parseExpandedNodeId("nsu=http://opcfoundation.org/UA/;i=47");
        return this.findPlaceholders(BaseVariableType.class, expandedNodeId, expandedNodeId2);
    }
}

