/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.EventData;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.server.EventManager;
import com.prosysopc.ua.server.ModelChangeType;
import com.prosysopc.ua.server.nodes.InternalHelper;
import com.prosysopc.ua.server.nodes.ServerNode;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.NodeClass;
import com.prosysopc.ua.types.opcua.ConditionType;
import com.prosysopc.ua.types.opcua.server.BaseEventTypeNodeBase;
import com.prosysopc.ua.types.opcua.server.ServerTypeNode;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2041")
public class BaseEventTypeNode
extends BaseEventTypeNodeBase {
    private static boolean Ht = true;
    private static final Set<NodeClass> Hu = new CopyOnWriteArraySet<NodeClass>();
    private static final Logger logger = LoggerFactory.getLogger(BaseEventTypeNode.class);
    protected final AtomicReference<EventData> lastEvent = new AtomicReference<Object>(null);

    public static Set<NodeClass> getExcludedsubnodeclasses() {
        return Hu;
    }

    public static boolean isDeleteOneShotEvents() {
        return Ht;
    }

    public static void setDeleteOneShotEvents(boolean bl) {
        Ht = bl;
    }

    protected BaseEventTypeNode(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        try {
            this.setSource(this.getNodeManager().getNode(Identifiers.Server));
            NodeId nodeId = this.getAddressSpace().getNamespaceTable().toNodeId(this.getDefaultTypeDefinition());
            if (Identifiers.BaseObjectType.equals(nodeId)) {
                nodeId = this.getNodeManager().getNamespaceTable().toNodeId(this.getTypeDefinitionId());
            }
            this.setEventType(nodeId);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        super.afterCreate();
    }

    public EventData getLastEvent() {
        return this.lastEvent == null ? null : this.lastEvent.get();
    }

    public UaNode getSource() {
        return this.getAddressSpace().findNode(this.getSourceNode());
    }

    @Override
    public String getSourceName() {
        UaNode uaNode;
        String string = super.getSourceName();
        if (string == null && this.getSourceNode() != null && (uaNode = this.getSource()) != null) {
            return uaNode.getDisplayName().getText();
        }
        return string;
    }

    @Override
    public NodeId getSourceNode() {
        return super.getSourceNode();
    }

    public boolean isMonitoredForEvents() {
        return this.isMonitoredForEvents(this);
    }

    @Override
    public void setSeverity(int n2) {
        this.setSeverity(UnsignedShort.valueOf(n2));
    }

    @Override
    public void setSeverity(UnsignedShort unsignedShort) {
        super.setSeverity(unsignedShort);
    }

    public void setSource(UaNode uaNode) {
        this.setSourceNode(uaNode.getNodeId());
        this.setSourceName(uaNode.getDisplayName().getText());
    }

    @Override
    public void setSourceName(String string) {
        super.setSourceName(string);
    }

    public ByteString triggerEvent(ByteString byteString) {
        return this.triggerEvent(DateTime.currentTime(), null, byteString);
    }

    public ByteString triggerEvent(DateTime dateTime, DateTime dateTime2, ByteString byteString) {
        ServerTypeNode serverTypeNode;
        UaNode uaNode;
        this.setEventId(EventManager.createFullEventId(byteString));
        this.setTime(dateTime == null ? DateTime.currentTime() : dateTime);
        this.setReceiveTime(dateTime2 == null ? this.getTime() : dateTime2);
        EventData eventData = EventData.fromNodeHierarchy((UaNode)this, this.getEventId(), BaseEventTypeNode.getExcludedsubnodeclasses());
        if (logger.isDebugEnabled()) {
            logger.debug("triggerEvent: event=" + eventData);
        }
        this.lastEvent.set(eventData);
        ArrayList<ServerNode> arrayList = new ArrayList<ServerNode>();
        if (!this.getNodeId().isNullNodeId()) {
            this.fireEvent(eventData, arrayList);
        }
        if ((uaNode = this.getSource()) != null && !arrayList.contains(uaNode)) {
            this.a(eventData, uaNode, arrayList);
        }
        if (!arrayList.contains(serverTypeNode = this.getAddressSpace().getNodeManagerRoot().getServerData())) {
            this.a(eventData, serverTypeNode, arrayList);
        }
        ByteString byteString2 = this.getEventId();
        if (Ht && !ConditionType.class.isAssignableFrom(this.getClass())) {
            try {
                this.getNodeManager().deleteNode(this, true, true);
            }
            catch (StatusException statusException) {
                logger.warn("Could not delete one-shot event " + this.getClass(), statusException);
            }
        }
        return byteString2;
    }

    private void a(EventData eventData, UaNode uaNode, List<ServerNode> list) {
        if (uaNode instanceof ServerNode) {
            ServerNode serverNode = (ServerNode)uaNode;
            InternalHelper.invokeFireEvent(serverNode, eventData, list);
        }
    }

    @Override
    protected void afterAddReference(UaReference uaReference) {
        if (this instanceof ConditionType) {
            super.afterAddReference(uaReference);
        }
        this.getNodeManager().getNodeManagerTable().getNodeManagerRoot().addModelChange(this, ModelChangeType.ReferenceAdded);
    }

    static {
        HashSet<NodeClass> hashSet = new HashSet<NodeClass>();
        hashSet.addAll(EnumSet.allOf(NodeClass.class));
        hashSet.remove(NodeClass.Variable);
        hashSet.remove(NodeClass.Object);
        Hu.addAll(hashSet);
    }
}

