/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.AuthorizationServiceConfigurationType;
import com.prosysopc.ua.types.opcua.server.AuthorizationServiceConfigurationTypeNode;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=17852")
public abstract class AuthorizationServiceConfigurationTypeNodeBase
extends BaseObjectTypeNode
implements AuthorizationServiceConfigurationType {
    private static GeneratedNodeInitializer<AuthorizationServiceConfigurationTypeNode> Ho;

    protected AuthorizationServiceConfigurationTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<AuthorizationServiceConfigurationTypeNode> generatedNodeInitializer = AuthorizationServiceConfigurationTypeNodeBase.getAuthorizationServiceConfigurationTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((AuthorizationServiceConfigurationTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<AuthorizationServiceConfigurationTypeNode> getAuthorizationServiceConfigurationTypeNodeInitializer() {
        return Ho;
    }

    public static void setAuthorizationServiceConfigurationTypeNodeInitializer(GeneratedNodeInitializer<AuthorizationServiceConfigurationTypeNode> generatedNodeInitializer) {
        Ho = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getServiceUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ServiceUri");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getServiceUri() {
        UaProperty uaProperty = this.getServiceUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ServiceUri does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setServiceUri(String string) {
        UaProperty uaProperty = this.getServiceUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ServiceUri failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ServiceUri failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getIssuerEndpointUrlNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "IssuerEndpointUrl");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getIssuerEndpointUrl() {
        UaProperty uaProperty = this.getIssuerEndpointUrlNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node IssuerEndpointUrl does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setIssuerEndpointUrl(String string) {
        UaProperty uaProperty = this.getIssuerEndpointUrlNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting IssuerEndpointUrl failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting IssuerEndpointUrl failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getServiceCertificateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ServiceCertificate");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public ByteString getServiceCertificate() {
        UaProperty uaProperty = this.getServiceCertificateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ServiceCertificate does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (ByteString)object;
    }

    @Override
    @Mandatory
    public void setServiceCertificate(ByteString byteString) {
        UaProperty uaProperty = this.getServiceCertificateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ServiceCertificate failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(byteString);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ServiceCertificate failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

