/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.AuditUpdateMethodEventType;
import com.prosysopc.ua.types.opcua.server.AuditEventTypeNode;
import com.prosysopc.ua.types.opcua.server.AuditUpdateMethodEventTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2127")
public abstract class AuditUpdateMethodEventTypeNodeBase
extends AuditEventTypeNode
implements AuditUpdateMethodEventType {
    private static GeneratedNodeInitializer<AuditUpdateMethodEventTypeNode> Hk;

    protected AuditUpdateMethodEventTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<AuditUpdateMethodEventTypeNode> generatedNodeInitializer = AuditUpdateMethodEventTypeNodeBase.getAuditUpdateMethodEventTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((AuditUpdateMethodEventTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<AuditUpdateMethodEventTypeNode> getAuditUpdateMethodEventTypeNodeInitializer() {
        return Hk;
    }

    public static void setAuditUpdateMethodEventTypeNodeInitializer(GeneratedNodeInitializer<AuditUpdateMethodEventTypeNode> generatedNodeInitializer) {
        Hk = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getInputArgumentsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "InputArguments");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Object[] getInputArguments() {
        UaProperty uaProperty = this.getInputArgumentsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node InputArguments does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Object[])object;
    }

    @Override
    @Mandatory
    public void setInputArguments(Object[] objectArray) {
        UaProperty uaProperty = this.getInputArgumentsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting InputArguments failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(objectArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting InputArguments failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getMethodIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MethodId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getMethodId() {
        UaProperty uaProperty = this.getMethodIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node MethodId does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setMethodId(NodeId nodeId) {
        UaProperty uaProperty = this.getMethodIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MethodId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(nodeId);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MethodId failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

