/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.core.SecurityTokenRequestType;
import com.prosysopc.ua.types.opcua.AuditOpenSecureChannelEventType;
import com.prosysopc.ua.types.opcua.server.AuditChannelEventTypeNode;
import com.prosysopc.ua.types.opcua.server.AuditOpenSecureChannelEventTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2060")
public abstract class AuditOpenSecureChannelEventTypeNodeBase
extends AuditChannelEventTypeNode
implements AuditOpenSecureChannelEventType {
    private static GeneratedNodeInitializer<AuditOpenSecureChannelEventTypeNode> Hf;

    protected AuditOpenSecureChannelEventTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<AuditOpenSecureChannelEventTypeNode> generatedNodeInitializer = AuditOpenSecureChannelEventTypeNodeBase.getAuditOpenSecureChannelEventTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((AuditOpenSecureChannelEventTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<AuditOpenSecureChannelEventTypeNode> getAuditOpenSecureChannelEventTypeNodeInitializer() {
        return Hf;
    }

    public static void setAuditOpenSecureChannelEventTypeNodeInitializer(GeneratedNodeInitializer<AuditOpenSecureChannelEventTypeNode> generatedNodeInitializer) {
        Hf = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getSecurityPolicyUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SecurityPolicyUri");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getSecurityPolicyUri() {
        UaProperty uaProperty = this.getSecurityPolicyUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node SecurityPolicyUri does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setSecurityPolicyUri(String string) {
        UaProperty uaProperty = this.getSecurityPolicyUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SecurityPolicyUri failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SecurityPolicyUri failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getRequestTypeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RequestType");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public SecurityTokenRequestType getRequestType() {
        UaProperty uaProperty = this.getRequestTypeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node RequestType does not exist");
        }
        Variant variant = uaProperty.getValue().getValue();
        return (SecurityTokenRequestType)variant.asEnum(SecurityTokenRequestType.class);
    }

    @Override
    @Mandatory
    public void setRequestType(SecurityTokenRequestType securityTokenRequestType) {
        UaProperty uaProperty = this.getRequestTypeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting RequestType failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(securityTokenRequestType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting RequestType failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getCertificateErrorEventIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CertificateErrorEventId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public ByteString getCertificateErrorEventId() {
        UaProperty uaProperty = this.getCertificateErrorEventIdNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (ByteString)object;
    }

    @Override
    @Optional
    public void setCertificateErrorEventId(ByteString byteString) {
        UaProperty uaProperty = this.getCertificateErrorEventIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting CertificateErrorEventId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(byteString);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting CertificateErrorEventId failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getClientCertificateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ClientCertificate");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public ByteString getClientCertificate() {
        UaProperty uaProperty = this.getClientCertificateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ClientCertificate does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (ByteString)object;
    }

    @Override
    @Mandatory
    public void setClientCertificate(ByteString byteString) {
        UaProperty uaProperty = this.getClientCertificateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ClientCertificate failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(byteString);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ClientCertificate failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getClientCertificateThumbprintNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ClientCertificateThumbprint");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getClientCertificateThumbprint() {
        UaProperty uaProperty = this.getClientCertificateThumbprintNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ClientCertificateThumbprint does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setClientCertificateThumbprint(String string) {
        UaProperty uaProperty = this.getClientCertificateThumbprintNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ClientCertificateThumbprint failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ClientCertificateThumbprint failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getSecurityModeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SecurityMode");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public MessageSecurityMode getSecurityMode() {
        UaProperty uaProperty = this.getSecurityModeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node SecurityMode does not exist");
        }
        Variant variant = uaProperty.getValue().getValue();
        return (MessageSecurityMode)variant.asEnum(MessageSecurityMode.class);
    }

    @Override
    @Mandatory
    public void setSecurityMode(MessageSecurityMode messageSecurityMode) {
        UaProperty uaProperty = this.getSecurityModeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SecurityMode failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(messageSecurityMode);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SecurityMode failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getRequestedLifetimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RequestedLifetime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getRequestedLifetime() {
        UaProperty uaProperty = this.getRequestedLifetimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node RequestedLifetime does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setRequestedLifetime(Double d2) {
        UaProperty uaProperty = this.getRequestedLifetimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting RequestedLifetime failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting RequestedLifetime failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

