/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.AuditCertificateEventType;
import com.prosysopc.ua.types.opcua.server.AuditCertificateEventTypeNode;
import com.prosysopc.ua.types.opcua.server.AuditSecurityEventTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2080")
public abstract class AuditCertificateEventTypeNodeBase
extends AuditSecurityEventTypeNode
implements AuditCertificateEventType {
    private static GeneratedNodeInitializer<AuditCertificateEventTypeNode> Gw;

    protected AuditCertificateEventTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<AuditCertificateEventTypeNode> generatedNodeInitializer = AuditCertificateEventTypeNodeBase.getAuditCertificateEventTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((AuditCertificateEventTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<AuditCertificateEventTypeNode> getAuditCertificateEventTypeNodeInitializer() {
        return Gw;
    }

    public static void setAuditCertificateEventTypeNodeInitializer(GeneratedNodeInitializer<AuditCertificateEventTypeNode> generatedNodeInitializer) {
        Gw = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getCertificateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Certificate");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public ByteString getCertificate() {
        UaProperty uaProperty = this.getCertificateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node Certificate does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (ByteString)object;
    }

    @Override
    @Mandatory
    public void setCertificate(ByteString byteString) {
        UaProperty uaProperty = this.getCertificateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Certificate failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(byteString);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Certificate failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

