/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.AxisScaleEnumeration;
import com.prosysopc.ua.stack.core.EUInformation;
import com.prosysopc.ua.stack.core.Range;
import com.prosysopc.ua.types.opcua.ArrayItemType;
import com.prosysopc.ua.types.opcua.server.ArrayItemTypeNode;
import com.prosysopc.ua.types.opcua.server.DataItemTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=12021")
public abstract class ArrayItemTypeNodeBase
extends DataItemTypeNode
implements ArrayItemType {
    private static GeneratedNodeInitializer<ArrayItemTypeNode> Gp;

    protected ArrayItemTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<ArrayItemTypeNode> generatedNodeInitializer = ArrayItemTypeNodeBase.getArrayItemTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((ArrayItemTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<ArrayItemTypeNode> getArrayItemTypeNodeInitializer() {
        return Gp;
    }

    public static void setArrayItemTypeNodeInitializer(GeneratedNodeInitializer<ArrayItemTypeNode> generatedNodeInitializer) {
        Gp = generatedNodeInitializer;
    }

    @Override
    @Optional
    public UaProperty getInstrumentRangeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "InstrumentRange");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Range getInstrumentRange() {
        UaProperty uaProperty = this.getInstrumentRangeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Range)object;
    }

    @Override
    @Optional
    public void setInstrumentRange(Range range) {
        UaProperty uaProperty = this.getInstrumentRangeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting InstrumentRange failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(range);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting InstrumentRange failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getEURangeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EURange");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Range getEURange() {
        UaProperty uaProperty = this.getEURangeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node EURange does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Range)object;
    }

    @Override
    @Mandatory
    public void setEURange(Range range) {
        UaProperty uaProperty = this.getEURangeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EURange failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(range);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting EURange failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getEngineeringUnitsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EngineeringUnits");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public EUInformation getEngineeringUnits() {
        UaProperty uaProperty = this.getEngineeringUnitsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node EngineeringUnits does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (EUInformation)object;
    }

    @Override
    @Mandatory
    public void setEngineeringUnits(EUInformation eUInformation) {
        UaProperty uaProperty = this.getEngineeringUnitsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EngineeringUnits failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(eUInformation);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting EngineeringUnits failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getTitleNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Title");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getTitle() {
        UaProperty uaProperty = this.getTitleNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node Title does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setTitle(LocalizedText localizedText) {
        UaProperty uaProperty = this.getTitleNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Title failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(localizedText);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Title failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getAxisScaleTypeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AxisScaleType");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public AxisScaleEnumeration getAxisScaleType() {
        UaProperty uaProperty = this.getAxisScaleTypeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node AxisScaleType does not exist");
        }
        Variant variant = uaProperty.getValue().getValue();
        return (AxisScaleEnumeration)variant.asEnum(AxisScaleEnumeration.class);
    }

    @Override
    @Mandatory
    public void setAxisScaleType(AxisScaleEnumeration axisScaleEnumeration) {
        UaProperty uaProperty = this.getAxisScaleTypeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting AxisScaleType failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(axisScaleEnumeration);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting AxisScaleType failed unexpectedly", statusException);
        }
    }
}

