/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.core.Range;
import com.prosysopc.ua.types.opcua.AnalogItemType;
import com.prosysopc.ua.types.opcua.server.AnalogItemTypeNode;
import com.prosysopc.ua.types.opcua.server.BaseAnalogTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2368")
public abstract class AnalogItemTypeNodeBase
extends BaseAnalogTypeNode
implements AnalogItemType {
    private static GeneratedNodeInitializer<AnalogItemTypeNode> Gk;

    protected AnalogItemTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<AnalogItemTypeNode> generatedNodeInitializer = AnalogItemTypeNodeBase.getAnalogItemTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((AnalogItemTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<AnalogItemTypeNode> getAnalogItemTypeNodeInitializer() {
        return Gk;
    }

    public static void setAnalogItemTypeNodeInitializer(GeneratedNodeInitializer<AnalogItemTypeNode> generatedNodeInitializer) {
        Gk = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getEURangeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EURange");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Range getEURange() {
        UaProperty uaProperty = this.getEURangeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node EURange does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Range)object;
    }

    @Override
    @Mandatory
    public void setEURange(Range range) {
        UaProperty uaProperty = this.getEURangeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EURange failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(range);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting EURange failed unexpectedly", statusException);
        }
    }
}

