/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.types.opcua.AlarmRateVariableType;
import com.prosysopc.ua.types.opcua.server.AlarmRateVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=17277")
public abstract class AlarmRateVariableTypeNodeBase
extends BaseDataVariableTypeNode
implements AlarmRateVariableType {
    private static GeneratedNodeInitializer<AlarmRateVariableTypeNode> Gd;

    protected AlarmRateVariableTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<AlarmRateVariableTypeNode> generatedNodeInitializer = AlarmRateVariableTypeNodeBase.getAlarmRateVariableTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((AlarmRateVariableTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<AlarmRateVariableTypeNode> getAlarmRateVariableTypeNodeInitializer() {
        return Gd;
    }

    public static void setAlarmRateVariableTypeNodeInitializer(GeneratedNodeInitializer<AlarmRateVariableTypeNode> generatedNodeInitializer) {
        Gd = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getRateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Rate");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getRate() {
        UaProperty uaProperty = this.getRateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node Rate does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setRate(UnsignedShort unsignedShort) {
        UaProperty uaProperty = this.getRateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Rate failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedShort);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Rate failed unexpectedly", statusException);
        }
    }

    public void setRate(int n2) {
        this.setRate(UnsignedShort.valueOf(n2));
    }
}

