/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.AlarmMetricsType;
import com.prosysopc.ua.types.opcua.server.AlarmMetricsTypeNode;
import com.prosysopc.ua.types.opcua.server.AlarmMetricsTypeResetMethod;
import com.prosysopc.ua.types.opcua.server.AlarmRateVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=17279")
public abstract class AlarmMetricsTypeNodeBase
extends BaseObjectTypeNode
implements AlarmMetricsType {
    private static GeneratedNodeInitializer<AlarmMetricsTypeNode> Gb;
    private static AlarmMetricsTypeResetMethod Gc;

    protected AlarmMetricsTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getMaximumAlarmRateNode());
        this.callAfterCreateIfExists(this.getMaximumActiveStateNode());
        this.callAfterCreateIfExists(this.getAlarmCountNode());
        this.callAfterCreateIfExists(this.getAverageAlarmRateNode());
        this.callAfterCreateIfExists(this.getMaximumReAlarmCountNode());
        this.callAfterCreateIfExists(this.getStartTimeNode());
        this.callAfterCreateIfExists(this.getMaximumUnAckNode());
        this.callAfterCreateIfExists(this.getCurrentAlarmRateNode());
        GeneratedNodeInitializer<AlarmMetricsTypeNode> generatedNodeInitializer = AlarmMetricsTypeNodeBase.getAlarmMetricsTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((AlarmMetricsTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<AlarmMetricsTypeNode> getAlarmMetricsTypeNodeInitializer() {
        return Gb;
    }

    public static void setAlarmMetricsTypeNodeInitializer(GeneratedNodeInitializer<AlarmMetricsTypeNode> generatedNodeInitializer) {
        Gb = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public AlarmRateVariableTypeNode getMaximumAlarmRateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaximumAlarmRate");
        return (AlarmRateVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getMaximumAlarmRate() {
        AlarmRateVariableTypeNode alarmRateVariableTypeNode = this.getMaximumAlarmRateNode();
        if (alarmRateVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node MaximumAlarmRate does not exist");
        }
        Object object = alarmRateVariableTypeNode.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setMaximumAlarmRate(Double d2) {
        AlarmRateVariableTypeNode alarmRateVariableTypeNode = this.getMaximumAlarmRateNode();
        if (alarmRateVariableTypeNode == null) {
            throw new RuntimeException("Setting MaximumAlarmRate failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            alarmRateVariableTypeNode.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MaximumAlarmRate failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getMaximumActiveStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaximumActiveState");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getMaximumActiveState() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getMaximumActiveStateNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node MaximumActiveState does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setMaximumActiveState(Double d2) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getMaximumActiveStateNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting MaximumActiveState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MaximumActiveState failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getAlarmCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AlarmCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getAlarmCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getAlarmCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node AlarmCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setAlarmCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getAlarmCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting AlarmCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting AlarmCount failed unexpectedly", statusException);
        }
    }

    public void setAlarmCount(long l2) {
        this.setAlarmCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public AlarmRateVariableTypeNode getAverageAlarmRateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AverageAlarmRate");
        return (AlarmRateVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getAverageAlarmRate() {
        AlarmRateVariableTypeNode alarmRateVariableTypeNode = this.getAverageAlarmRateNode();
        if (alarmRateVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node AverageAlarmRate does not exist");
        }
        Object object = alarmRateVariableTypeNode.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setAverageAlarmRate(Double d2) {
        AlarmRateVariableTypeNode alarmRateVariableTypeNode = this.getAverageAlarmRateNode();
        if (alarmRateVariableTypeNode == null) {
            throw new RuntimeException("Setting AverageAlarmRate failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            alarmRateVariableTypeNode.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting AverageAlarmRate failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getMaximumReAlarmCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaximumReAlarmCount");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getMaximumReAlarmCount() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getMaximumReAlarmCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node MaximumReAlarmCount does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setMaximumReAlarmCount(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getMaximumReAlarmCountNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting MaximumReAlarmCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MaximumReAlarmCount failed unexpectedly", statusException);
        }
    }

    public void setMaximumReAlarmCount(long l2) {
        this.setMaximumReAlarmCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getStartTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "StartTime");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getStartTime() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getStartTimeNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node StartTime does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setStartTime(DateTime dateTime) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getStartTimeNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting StartTime failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(dateTime);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting StartTime failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getMaximumUnAckNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaximumUnAck");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getMaximumUnAck() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getMaximumUnAckNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node MaximumUnAck does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setMaximumUnAck(Double d2) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getMaximumUnAckNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting MaximumUnAck failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MaximumUnAck failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public AlarmRateVariableTypeNode getCurrentAlarmRateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CurrentAlarmRate");
        return (AlarmRateVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getCurrentAlarmRate() {
        AlarmRateVariableTypeNode alarmRateVariableTypeNode = this.getCurrentAlarmRateNode();
        if (alarmRateVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node CurrentAlarmRate does not exist");
        }
        Object object = alarmRateVariableTypeNode.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setCurrentAlarmRate(Double d2) {
        AlarmRateVariableTypeNode alarmRateVariableTypeNode = this.getCurrentAlarmRateNode();
        if (alarmRateVariableTypeNode == null) {
            throw new RuntimeException("Setting CurrentAlarmRate failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            alarmRateVariableTypeNode.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting CurrentAlarmRate failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "Reset"), nodeId)) {
            this.e(serviceContext);
            return null;
        }
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    @Mandatory
    public UaMethod getResetNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Reset");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onReset(ServiceContext var1) throws StatusException;

    @Override
    public void reset() throws StatusException {
        this.e(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    private void e(ServiceContext serviceContext) throws StatusException {
        AlarmMetricsTypeResetMethod alarmMetricsTypeResetMethod = AlarmMetricsTypeNodeBase.getResetMethodImplementation();
        if (alarmMetricsTypeResetMethod != null) {
            alarmMetricsTypeResetMethod.reset(serviceContext, (AlarmMetricsTypeNode)this);
        } else {
            this.onReset(serviceContext);
        }
    }

    public static AlarmMetricsTypeResetMethod getResetMethodImplementation() {
        return Gc;
    }

    public static void setResetMethodImplementation(AlarmMetricsTypeResetMethod alarmMetricsTypeResetMethod) {
        Gc = alarmMetricsTypeResetMethod;
    }
}

