/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.MethodArgumentTransformer;
import com.prosysopc.ua.MethodCallStatusException;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.TrustListValidationOptions;
import com.prosysopc.ua.stack.transport.AsyncResult;
import com.prosysopc.ua.types.opcua.TrustListType;
import com.prosysopc.ua.types.opcua.client.FileTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=12522")
public abstract class TrustListTypeImplBase
extends FileTypeImpl
implements TrustListType {
    protected TrustListTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Optional
    public UaProperty getUpdateFrequencyNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "UpdateFrequency");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Double getUpdateFrequency() {
        UaProperty uaProperty = this.getUpdateFrequencyNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Optional
    public void setUpdateFrequency(Double d2) throws StatusException {
        UaProperty uaProperty = this.getUpdateFrequencyNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting UpdateFrequency failed, the Optional node does not exist)");
        }
        uaProperty.setValue(d2);
    }

    @Override
    @Mandatory
    public UaProperty getLastUpdateTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LastUpdateTime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getLastUpdateTime() {
        UaProperty uaProperty = this.getLastUpdateTimeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setLastUpdateTime(DateTime dateTime) throws StatusException {
        UaProperty uaProperty = this.getLastUpdateTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting LastUpdateTime failed, the Optional node does not exist)");
        }
        uaProperty.setValue(dateTime);
    }

    @Override
    @Optional
    public UaProperty getDefaultValidationOptionsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DefaultValidationOptions");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public TrustListValidationOptions getDefaultValidationOptions() {
        UaProperty uaProperty = this.getDefaultValidationOptionsNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (TrustListValidationOptions)object;
    }

    @Override
    @Optional
    public void setDefaultValidationOptions(TrustListValidationOptions trustListValidationOptions) throws StatusException {
        UaProperty uaProperty = this.getDefaultValidationOptionsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DefaultValidationOptions failed, the Optional node does not exist)");
        }
        uaProperty.setValue(trustListValidationOptions);
    }

    @Override
    @Optional
    public UaProperty getActivityTimeoutNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ActivityTimeout");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Double getActivityTimeout() {
        UaProperty uaProperty = this.getActivityTimeoutNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Optional
    public void setActivityTimeout(Double d2) throws StatusException {
        UaProperty uaProperty = this.getActivityTimeoutNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ActivityTimeout failed, the Optional node does not exist)");
        }
        uaProperty.setValue(d2);
    }

    @Override
    @Mandatory
    public UaMethod getAddCertificateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AddCertificate");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    @Override
    public void addCertificate(ByteString byteString, Boolean bl) throws MethodCallStatusException, ServiceException {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "AddCertificate"));
        this.call(nodeId, byteString, bl);
    }

    public AsyncResult<Void> addCertificateAsync(ByteString byteString, Boolean bl) {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "AddCertificate"));
        return this.callAsync(nodeId, new MethodArgumentTransformer<Void>(){

            public Void i(Variant[] variantArray) {
                return null;
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.i(variantArray);
            }
        }, byteString, bl);
    }

    @Override
    @Mandatory
    public UaMethod getOpenWithMasksNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "OpenWithMasks");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    @Override
    public UnsignedInteger openWithMasks(UnsignedInteger unsignedInteger) throws MethodCallStatusException, ServiceException {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "OpenWithMasks"));
        return this.call(nodeId, new MethodArgumentTransformer<UnsignedInteger>(){

            public UnsignedInteger w(Variant[] variantArray) {
                return (UnsignedInteger)variantArray[0].getValue();
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.w(variantArray);
            }
        }, unsignedInteger);
    }

    public AsyncResult<? extends UnsignedInteger> openWithMasksAsync(UnsignedInteger unsignedInteger) {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "OpenWithMasks"));
        return this.callAsync(nodeId, new MethodArgumentTransformer<UnsignedInteger>(){

            public UnsignedInteger w(Variant[] variantArray) {
                return (UnsignedInteger)variantArray[0].getValue();
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.w(variantArray);
            }
        }, unsignedInteger);
    }

    @Override
    @Mandatory
    public UaMethod getRemoveCertificateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveCertificate");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    @Override
    public void removeCertificate(String string, Boolean bl) throws MethodCallStatusException, ServiceException {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveCertificate"));
        this.call(nodeId, string, bl);
    }

    public AsyncResult<Void> removeCertificateAsync(String string, Boolean bl) {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveCertificate"));
        return this.callAsync(nodeId, new MethodArgumentTransformer<Void>(){

            public Void i(Variant[] variantArray) {
                return null;
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.i(variantArray);
            }
        }, string, bl);
    }

    @Override
    @Mandatory
    public UaMethod getCloseAndUpdateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CloseAndUpdate");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    @Override
    public Boolean closeAndUpdate(UnsignedInteger unsignedInteger) throws MethodCallStatusException, ServiceException {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "CloseAndUpdate"));
        return this.call(nodeId, new MethodArgumentTransformer<Boolean>(){

            public Boolean f(Variant[] variantArray) {
                return (Boolean)variantArray[0].getValue();
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.f(variantArray);
            }
        }, unsignedInteger);
    }

    public AsyncResult<? extends Boolean> closeAndUpdateAsync(UnsignedInteger unsignedInteger) {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "CloseAndUpdate"));
        return this.callAsync(nodeId, new MethodArgumentTransformer<Boolean>(){

            public Boolean f(Variant[] variantArray) {
                return (Boolean)variantArray[0].getValue();
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.f(variantArray);
            }
        }, unsignedInteger);
    }
}

