/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.ServerState;
import com.prosysopc.ua.types.opcua.SystemStatusChangeEventType;
import com.prosysopc.ua.types.opcua.client.SystemEventTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=11446")
public abstract class SystemStatusChangeEventTypeImplBase
extends SystemEventTypeImpl
implements SystemStatusChangeEventType {
    protected SystemStatusChangeEventTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Mandatory
    public UaProperty getSystemStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SystemState");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public ServerState getSystemState() {
        UaProperty uaProperty = this.getSystemStateNode();
        if (uaProperty == null) {
            return null;
        }
        Variant variant = uaProperty.getValue().getValue();
        return (ServerState)variant.asEnum(ServerState.class);
    }

    @Override
    @Mandatory
    public void setSystemState(ServerState serverState) throws StatusException {
        UaProperty uaProperty = this.getSystemStateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SystemState failed, the Optional node does not exist)");
        }
        uaProperty.setValue(serverState);
    }
}

