/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.EndpointDescription;
import com.prosysopc.ua.stack.core.KeyValuePair;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.types.opcua.PubSubGroupType;
import com.prosysopc.ua.types.opcua.PubSubStatusType;
import com.prosysopc.ua.types.opcua.client.BaseObjectTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=14232")
public abstract class PubSubGroupTypeImplBase
extends BaseObjectTypeImpl
implements PubSubGroupType {
    protected PubSubGroupTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Mandatory
    public UaProperty getSecurityModeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SecurityMode");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public MessageSecurityMode getSecurityMode() {
        UaProperty uaProperty = this.getSecurityModeNode();
        if (uaProperty == null) {
            return null;
        }
        Variant variant = uaProperty.getValue().getValue();
        return (MessageSecurityMode)variant.asEnum(MessageSecurityMode.class);
    }

    @Override
    @Mandatory
    public void setSecurityMode(MessageSecurityMode messageSecurityMode) throws StatusException {
        UaProperty uaProperty = this.getSecurityModeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SecurityMode failed, the Optional node does not exist)");
        }
        uaProperty.setValue(messageSecurityMode);
    }

    @Override
    @Optional
    public UaProperty getSecurityGroupIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SecurityGroupId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getSecurityGroupId() {
        UaProperty uaProperty = this.getSecurityGroupIdNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setSecurityGroupId(String string) throws StatusException {
        UaProperty uaProperty = this.getSecurityGroupIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SecurityGroupId failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Optional
    public UaProperty getSecurityKeyServicesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SecurityKeyServices");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public EndpointDescription[] getSecurityKeyServices() {
        UaProperty uaProperty = this.getSecurityKeyServicesNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (EndpointDescription[])object;
    }

    @Override
    @Optional
    public void setSecurityKeyServices(EndpointDescription[] endpointDescriptionArray) throws StatusException {
        UaProperty uaProperty = this.getSecurityKeyServicesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SecurityKeyServices failed, the Optional node does not exist)");
        }
        uaProperty.setValue(endpointDescriptionArray);
    }

    @Override
    @Mandatory
    public UaProperty getMaxNetworkMessageSizeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxNetworkMessageSize");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getMaxNetworkMessageSize() {
        UaProperty uaProperty = this.getMaxNetworkMessageSizeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setMaxNetworkMessageSize(UnsignedInteger unsignedInteger) throws StatusException {
        UaProperty uaProperty = this.getMaxNetworkMessageSizeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxNetworkMessageSize failed, the Optional node does not exist)");
        }
        uaProperty.setValue(unsignedInteger);
    }

    @Override
    @Mandatory
    public UaProperty getGroupPropertiesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "GroupProperties");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public KeyValuePair[] getGroupProperties() {
        UaProperty uaProperty = this.getGroupPropertiesNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (KeyValuePair[])object;
    }

    @Override
    @Mandatory
    public void setGroupProperties(KeyValuePair[] keyValuePairArray) throws StatusException {
        UaProperty uaProperty = this.getGroupPropertiesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting GroupProperties failed, the Optional node does not exist)");
        }
        uaProperty.setValue(keyValuePairArray);
    }

    @Override
    @Mandatory
    public PubSubStatusType getStatusNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Status");
        return (PubSubStatusType)this.getComponent(qualifiedName);
    }
}

