/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.types.opcua.FolderType;
import com.prosysopc.ua.types.opcua.HistoricalEventConfigurationType;
import com.prosysopc.ua.types.opcua.client.BaseObjectTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=32621")
public abstract class HistoricalEventConfigurationTypeImplBase
extends BaseObjectTypeImpl
implements HistoricalEventConfigurationType {
    protected HistoricalEventConfigurationTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Optional
    public UaProperty getStartOfArchiveNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "StartOfArchive");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public DateTime getStartOfArchive() {
        UaProperty uaProperty = this.getStartOfArchiveNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Optional
    public void setStartOfArchive(DateTime dateTime) throws StatusException {
        UaProperty uaProperty = this.getStartOfArchiveNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting StartOfArchive failed, the Optional node does not exist)");
        }
        uaProperty.setValue(dateTime);
    }

    @Override
    @Optional
    public UaProperty getStartOfOnlineArchiveNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "StartOfOnlineArchive");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public DateTime getStartOfOnlineArchive() {
        UaProperty uaProperty = this.getStartOfOnlineArchiveNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Optional
    public void setStartOfOnlineArchive(DateTime dateTime) throws StatusException {
        UaProperty uaProperty = this.getStartOfOnlineArchiveNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting StartOfOnlineArchive failed, the Optional node does not exist)");
        }
        uaProperty.setValue(dateTime);
    }

    @Override
    @Mandatory
    public FolderType getEventTypesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EventTypes");
        return (FolderType)this.getComponent(qualifiedName);
    }
}

