/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.types.opcua.DiscrepancyAlarmType;
import com.prosysopc.ua.types.opcua.client.AlarmConditionTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=17080")
public abstract class DiscrepancyAlarmTypeImplBase
extends AlarmConditionTypeImpl
implements DiscrepancyAlarmType {
    protected DiscrepancyAlarmTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Optional
    public UaProperty getToleranceNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Tolerance");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Double getTolerance() {
        UaProperty uaProperty = this.getToleranceNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Optional
    public void setTolerance(Double d2) throws StatusException {
        UaProperty uaProperty = this.getToleranceNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Tolerance failed, the Optional node does not exist)");
        }
        uaProperty.setValue(d2);
    }

    @Override
    @Mandatory
    public UaProperty getExpectedTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ExpectedTime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getExpectedTime() {
        UaProperty uaProperty = this.getExpectedTimeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setExpectedTime(Double d2) throws StatusException {
        UaProperty uaProperty = this.getExpectedTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ExpectedTime failed, the Optional node does not exist)");
        }
        uaProperty.setValue(d2);
    }

    @Override
    @Mandatory
    public UaProperty getTargetValueNodeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TargetValueNode");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getTargetValueNode() {
        UaProperty uaProperty = this.getTargetValueNodeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setTargetValueNode(NodeId nodeId) throws StatusException {
        UaProperty uaProperty = this.getTargetValueNodeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting TargetValueNode failed, the Optional node does not exist)");
        }
        uaProperty.setValue(nodeId);
    }
}

