/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.QosDataType;
import com.prosysopc.ua.types.opcua.DatagramConnectionTransportType;
import com.prosysopc.ua.types.opcua.NetworkAddressType;
import com.prosysopc.ua.types.opcua.client.ConnectionTransportTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=15064")
public abstract class DatagramConnectionTransportTypeImplBase
extends ConnectionTransportTypeImpl
implements DatagramConnectionTransportType {
    protected DatagramConnectionTransportTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Optional
    public UaProperty getDiscoveryMaxMessageSizeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DiscoveryMaxMessageSize");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getDiscoveryMaxMessageSize() {
        UaProperty uaProperty = this.getDiscoveryMaxMessageSizeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setDiscoveryMaxMessageSize(UnsignedInteger unsignedInteger) throws StatusException {
        UaProperty uaProperty = this.getDiscoveryMaxMessageSizeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DiscoveryMaxMessageSize failed, the Optional node does not exist)");
        }
        uaProperty.setValue(unsignedInteger);
    }

    @Override
    @Optional
    public UaProperty getDiscoveryAnnounceRateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DiscoveryAnnounceRate");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getDiscoveryAnnounceRate() {
        UaProperty uaProperty = this.getDiscoveryAnnounceRateNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setDiscoveryAnnounceRate(UnsignedInteger unsignedInteger) throws StatusException {
        UaProperty uaProperty = this.getDiscoveryAnnounceRateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DiscoveryAnnounceRate failed, the Optional node does not exist)");
        }
        uaProperty.setValue(unsignedInteger);
    }

    @Override
    @Optional
    public UaProperty getQosCategoryNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "QosCategory");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getQosCategory() {
        UaProperty uaProperty = this.getQosCategoryNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setQosCategory(String string) throws StatusException {
        UaProperty uaProperty = this.getQosCategoryNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting QosCategory failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Optional
    public UaProperty getDatagramQosNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DatagramQos");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public QosDataType[] getDatagramQos() {
        UaProperty uaProperty = this.getDatagramQosNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (QosDataType[])object;
    }

    @Override
    @Optional
    public void setDatagramQos(QosDataType[] qosDataTypeArray) throws StatusException {
        UaProperty uaProperty = this.getDatagramQosNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DatagramQos failed, the Optional node does not exist)");
        }
        uaProperty.setValue(qosDataTypeArray);
    }

    @Override
    @Mandatory
    public NetworkAddressType getDiscoveryAddressNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DiscoveryAddress");
        return (NetworkAddressType)this.getComponent(qualifiedName);
    }
}

