/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.types.opcua.AuthorizationServiceConfigurationType;
import com.prosysopc.ua.types.opcua.client.BaseObjectTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=17852")
public abstract class AuthorizationServiceConfigurationTypeImplBase
extends BaseObjectTypeImpl
implements AuthorizationServiceConfigurationType {
    protected AuthorizationServiceConfigurationTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Mandatory
    public UaProperty getServiceUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ServiceUri");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getServiceUri() {
        UaProperty uaProperty = this.getServiceUriNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setServiceUri(String string) throws StatusException {
        UaProperty uaProperty = this.getServiceUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ServiceUri failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Mandatory
    public UaProperty getIssuerEndpointUrlNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "IssuerEndpointUrl");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getIssuerEndpointUrl() {
        UaProperty uaProperty = this.getIssuerEndpointUrlNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setIssuerEndpointUrl(String string) throws StatusException {
        UaProperty uaProperty = this.getIssuerEndpointUrlNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting IssuerEndpointUrl failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Mandatory
    public UaProperty getServiceCertificateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ServiceCertificate");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public ByteString getServiceCertificate() {
        UaProperty uaProperty = this.getServiceCertificateNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (ByteString)object;
    }

    @Override
    @Mandatory
    public void setServiceCertificate(ByteString byteString) throws StatusException {
        UaProperty uaProperty = this.getServiceCertificateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ServiceCertificate failed, the Optional node does not exist)");
        }
        uaProperty.setValue(byteString);
    }
}

