/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.ApplicationType;
import com.prosysopc.ua.types.opcua.ApplicationConfigurationType;
import com.prosysopc.ua.types.opcua.client.ServerConfigurationTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=25731")
public abstract class ApplicationConfigurationTypeImplBase
extends ServerConfigurationTypeImpl
implements ApplicationConfigurationType {
    protected ApplicationConfigurationTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Mandatory
    public UaProperty getApplicationUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ApplicationUri");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getApplicationUri() {
        UaProperty uaProperty = this.getApplicationUriNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setApplicationUri(String string) throws StatusException {
        UaProperty uaProperty = this.getApplicationUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ApplicationUri failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Mandatory
    public UaProperty getProductUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ProductUri");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getProductUri() {
        UaProperty uaProperty = this.getProductUriNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setProductUri(String string) throws StatusException {
        UaProperty uaProperty = this.getProductUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ProductUri failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Mandatory
    public UaProperty getEnabledNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Enabled");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isEnabled() {
        UaProperty uaProperty = this.getEnabledNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setEnabled(Boolean bl) throws StatusException {
        UaProperty uaProperty = this.getEnabledNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Enabled failed, the Optional node does not exist)");
        }
        uaProperty.setValue(bl);
    }

    @Override
    @Mandatory
    public UaProperty getApplicationTypeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ApplicationType");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public ApplicationType getApplicationType() {
        UaProperty uaProperty = this.getApplicationTypeNode();
        if (uaProperty == null) {
            return null;
        }
        Variant variant = uaProperty.getValue().getValue();
        return (ApplicationType)variant.asEnum(ApplicationType.class);
    }

    @Override
    @Mandatory
    public void setApplicationType(ApplicationType applicationType) throws StatusException {
        UaProperty uaProperty = this.getApplicationTypeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ApplicationType failed, the Optional node does not exist)");
        }
        uaProperty.setValue(applicationType);
    }
}

