/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua;

import com.prosysopc.ua.MethodOutputArguments;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.ApplicationType;
import com.prosysopc.ua.types.opcua.BaseObjectType;
import com.prosysopc.ua.types.opcua.CertificateGroupFolderType;
import com.prosysopc.ua.types.opcua.TransactionDiagnosticsType;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=12581")
public interface ServerConfigurationType
extends BaseObjectType {
    public static final String APPLICATION_TYPE = "ApplicationType";
    public static final String PRODUCT_URI = "ProductUri";
    public static final String SERVER_CAPABILITIES = "ServerCapabilities";
    public static final String MULTICAST_DNS_ENABLED = "MulticastDnsEnabled";
    public static final String HAS_SECURE_ELEMENT = "HasSecureElement";
    public static final String APPLICATION_URI = "ApplicationUri";
    public static final String MAX_TRUST_LIST_SIZE = "MaxTrustListSize";
    public static final String SUPPORTED_PRIVATE_KEY_FORMATS = "SupportedPrivateKeyFormats";
    public static final String CERTIFICATE_GROUPS = "CertificateGroups";
    public static final String TRANSACTION_DIAGNOSTICS = "TransactionDiagnostics";
    public static final String CANCEL_CHANGES = "CancelChanges";
    public static final String APPLY_CHANGES = "ApplyChanges";
    public static final String GET_CERTIFICATES = "GetCertificates";
    public static final String GET_REJECTED_LIST = "GetRejectedList";
    public static final String UPDATE_CERTIFICATE = "UpdateCertificate";
    public static final String CREATE_SIGNING_REQUEST = "CreateSigningRequest";
    public static final String RESET_TO_SERVER_DEFAULTS = "ResetToServerDefaults";

    @Optional
    public UaProperty getApplicationTypeNode();

    @Optional
    public ApplicationType getApplicationType();

    @Optional
    public void setApplicationType(ApplicationType var1) throws StatusException;

    @Optional
    public UaProperty getProductUriNode();

    @Optional
    public String getProductUri();

    @Optional
    public void setProductUri(String var1) throws StatusException;

    @Mandatory
    public UaProperty getServerCapabilitiesNode();

    @Mandatory
    public String[] getServerCapabilities();

    @Mandatory
    public void setServerCapabilities(String[] var1) throws StatusException;

    @Mandatory
    public UaProperty getMulticastDnsEnabledNode();

    @Mandatory
    public Boolean isMulticastDnsEnabled();

    @Mandatory
    public void setMulticastDnsEnabled(Boolean var1) throws StatusException;

    @Optional
    public UaProperty getHasSecureElementNode();

    @Optional
    public Boolean isHasSecureElement();

    @Optional
    public void setHasSecureElement(Boolean var1) throws StatusException;

    @Optional
    public UaProperty getApplicationUriNode();

    @Optional
    public String getApplicationUri();

    @Optional
    public void setApplicationUri(String var1) throws StatusException;

    @Mandatory
    public UaProperty getMaxTrustListSizeNode();

    @Mandatory
    public UnsignedInteger getMaxTrustListSize();

    @Mandatory
    public void setMaxTrustListSize(UnsignedInteger var1) throws StatusException;

    @Mandatory
    public UaProperty getSupportedPrivateKeyFormatsNode();

    @Mandatory
    public String[] getSupportedPrivateKeyFormats();

    @Mandatory
    public void setSupportedPrivateKeyFormats(String[] var1) throws StatusException;

    @Mandatory
    public CertificateGroupFolderType getCertificateGroupsNode();

    @Optional
    public TransactionDiagnosticsType getTransactionDiagnosticsNode();

    @Optional
    public UaMethod getCancelChangesNode();

    public void cancelChanges() throws StatusException, ServiceException;

    @Mandatory
    public UaMethod getApplyChangesNode();

    public void applyChanges() throws StatusException, ServiceException;

    @Optional
    public UaMethod getGetCertificatesNode();

    public GetCertificatesMethodOutputs getCertificates(NodeId var1) throws StatusException, ServiceException;

    @Mandatory
    public UaMethod getGetRejectedListNode();

    public ByteString[] getRejectedList() throws StatusException, ServiceException;

    @Mandatory
    public UaMethod getUpdateCertificateNode();

    public Boolean updateCertificate(NodeId var1, NodeId var2, ByteString var3, ByteString[] var4, String var5, ByteString var6) throws StatusException, ServiceException;

    @Mandatory
    public UaMethod getCreateSigningRequestNode();

    public ByteString createSigningRequest(NodeId var1, NodeId var2, String var3, Boolean var4, ByteString var5) throws StatusException, ServiceException;

    @Optional
    public UaMethod getResetToServerDefaultsNode();

    public void resetToServerDefaults() throws StatusException, ServiceException;

    public static class GetCertificatesMethodOutputs
    implements MethodOutputArguments {
        protected NodeId[] f_certificateTypeIds;
        protected ByteString[] f_certificates;

        public GetCertificatesMethodOutputs(NodeId[] nodeIdArray, ByteString[] byteStringArray) {
            this.f_certificateTypeIds = nodeIdArray;
            this.f_certificates = byteStringArray;
        }

        public NodeId[] getCertificateTypeIds() {
            return this.f_certificateTypeIds;
        }

        public ByteString[] getCertificates() {
            return this.f_certificates;
        }

        @Override
        public final Variant[] asVariantArray() {
            return new Variant[]{new Variant(this.f_certificateTypeIds), new Variant(this.f_certificates)};
        }
    }
}

