/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua;

import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedLong;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.types.opcua.BaseObjectType;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=11575")
public interface FileType
extends BaseObjectType {
    public static final String OPEN_COUNT = "OpenCount";
    public static final String USER_WRITABLE = "UserWritable";
    public static final String MAX_BYTE_STRING_LENGTH = "MaxByteStringLength";
    public static final String MIME_TYPE = "MimeType";
    public static final String WRITABLE = "Writable";
    public static final String LAST_MODIFIED_TIME = "LastModifiedTime";
    public static final String SIZE = "Size";
    public static final String OPEN = "Open";
    public static final String GET_POSITION = "GetPosition";
    public static final String READ = "Read";
    public static final String CLOSE = "Close";
    public static final String WRITE = "Write";
    public static final String SET_POSITION = "SetPosition";

    @Mandatory
    public UaProperty getOpenCountNode();

    @Mandatory
    public UnsignedShort getOpenCount();

    @Mandatory
    public void setOpenCount(UnsignedShort var1) throws StatusException;

    @Mandatory
    public UaProperty getUserWritableNode();

    @Mandatory
    public Boolean isUserWritable();

    @Mandatory
    public void setUserWritable(Boolean var1) throws StatusException;

    @Optional
    public UaProperty getMaxByteStringLengthNode();

    @Optional
    public UnsignedInteger getMaxByteStringLength();

    @Optional
    public void setMaxByteStringLength(UnsignedInteger var1) throws StatusException;

    @Optional
    public UaProperty getMimeTypeNode();

    @Optional
    public String getMimeType();

    @Optional
    public void setMimeType(String var1) throws StatusException;

    @Mandatory
    public UaProperty getWritableNode();

    @Mandatory
    public Boolean isWritable();

    @Mandatory
    public void setWritable(Boolean var1) throws StatusException;

    @Optional
    public UaProperty getLastModifiedTimeNode();

    @Optional
    public DateTime getLastModifiedTime();

    @Optional
    public void setLastModifiedTime(DateTime var1) throws StatusException;

    @Mandatory
    public UaProperty getSizeNode();

    @Mandatory
    public UnsignedLong getSize();

    @Mandatory
    public void setSize(UnsignedLong var1) throws StatusException;

    @Mandatory
    public UaMethod getOpenNode();

    public UnsignedInteger open(UnsignedByte var1) throws StatusException, ServiceException;

    @Mandatory
    public UaMethod getGetPositionNode();

    public UnsignedLong getPosition(UnsignedInteger var1) throws StatusException, ServiceException;

    @Mandatory
    public UaMethod getReadNode();

    public ByteString read(UnsignedInteger var1, Integer var2) throws StatusException, ServiceException;

    @Mandatory
    public UaMethod getCloseNode();

    public void close(UnsignedInteger var1) throws StatusException, ServiceException;

    @Mandatory
    public UaMethod getWriteNode();

    public void write(UnsignedInteger var1, ByteString var2) throws StatusException, ServiceException;

    @Mandatory
    public UaMethod getSetPositionNode();

    public void setPosition(UnsignedInteger var1, UnsignedLong var2) throws StatusException, ServiceException;
}

