/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.gds.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.gds.ApplicationRecordDataType;
import com.prosysopc.ua.types.gds.DirectoryType;
import com.prosysopc.ua.types.gds.server.DirectoryTypeFindApplicationsMethod;
import com.prosysopc.ua.types.gds.server.DirectoryTypeGetApplicationMethod;
import com.prosysopc.ua.types.gds.server.DirectoryTypeNode;
import com.prosysopc.ua.types.gds.server.DirectoryTypeQueryApplicationsMethod;
import com.prosysopc.ua.types.gds.server.DirectoryTypeQueryServersMethod;
import com.prosysopc.ua.types.gds.server.DirectoryTypeRegisterApplicationMethod;
import com.prosysopc.ua.types.gds.server.DirectoryTypeUnregisterApplicationMethod;
import com.prosysopc.ua.types.gds.server.DirectoryTypeUpdateApplicationMethod;
import com.prosysopc.ua.types.opcua.server.FolderTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/GDS/;i=13")
public abstract class DirectoryTypeNodeBase
extends FolderTypeNode
implements DirectoryType {
    private static GeneratedNodeInitializer<DirectoryTypeNode> Ex;
    private static DirectoryTypeFindApplicationsMethod Ey;
    private static DirectoryTypeRegisterApplicationMethod Ez;
    private static DirectoryTypeUpdateApplicationMethod EA;
    private static DirectoryTypeUnregisterApplicationMethod EB;
    private static DirectoryTypeGetApplicationMethod EC;
    private static DirectoryTypeQueryApplicationsMethod ED;
    private static DirectoryTypeQueryServersMethod EE;

    protected DirectoryTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getApplicationsNode());
        GeneratedNodeInitializer<DirectoryTypeNode> generatedNodeInitializer = DirectoryTypeNodeBase.getDirectoryTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((DirectoryTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<DirectoryTypeNode> getDirectoryTypeNodeInitializer() {
        return Ex;
    }

    public static void setDirectoryTypeNodeInitializer(GeneratedNodeInitializer<DirectoryTypeNode> generatedNodeInitializer) {
        Ex = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public FolderTypeNode getApplicationsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/GDS/", "Applications");
        return (FolderTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/GDS/", "FindApplications"), nodeId)) {
            return new Variant[]{new Variant(this.a(serviceContext, (String)variantArray[0].getValue()))};
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/GDS/", "RegisterApplication"), nodeId)) {
            return new Variant[]{new Variant(this.a(serviceContext, (ApplicationRecordDataType)variantArray[0].getValue()))};
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/GDS/", "UpdateApplication"), nodeId)) {
            this.b(serviceContext, (ApplicationRecordDataType)variantArray[0].getValue());
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/GDS/", "UnregisterApplication"), nodeId)) {
            this.b(serviceContext, (NodeId)variantArray[0].getValue());
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/GDS/", "GetApplication"), nodeId)) {
            return new Variant[]{new Variant(this.c(serviceContext, (NodeId)variantArray[0].getValue()))};
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/GDS/", "QueryApplications"), nodeId)) {
            return this.a(serviceContext, (UnsignedInteger)variantArray[0].getValue(), (UnsignedInteger)variantArray[1].getValue(), (String)variantArray[2].getValue(), (String)variantArray[3].getValue(), (UnsignedInteger)variantArray[4].getValue(), (String)variantArray[5].getValue(), (String[])variantArray[6].getValue()).asVariantArray();
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/GDS/", "QueryServers"), nodeId)) {
            return this.a(serviceContext, (UnsignedInteger)variantArray[0].getValue(), (UnsignedInteger)variantArray[1].getValue(), (String)variantArray[2].getValue(), (String)variantArray[3].getValue(), (String)variantArray[4].getValue(), (String[])variantArray[5].getValue()).asVariantArray();
        }
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    @Mandatory
    public UaMethod getFindApplicationsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/GDS/", "FindApplications");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract ApplicationRecordDataType[] onFindApplications(ServiceContext var1, String var2) throws StatusException;

    @Override
    public ApplicationRecordDataType[] findApplications(String string) throws StatusException {
        return this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, string);
    }

    private ApplicationRecordDataType[] a(ServiceContext serviceContext, String string) throws StatusException {
        DirectoryTypeFindApplicationsMethod directoryTypeFindApplicationsMethod = DirectoryTypeNodeBase.getFindApplicationsMethodImplementation();
        if (directoryTypeFindApplicationsMethod != null) {
            return directoryTypeFindApplicationsMethod.findApplications(serviceContext, (DirectoryTypeNode)this, string);
        }
        return this.onFindApplications(serviceContext, string);
    }

    public static DirectoryTypeFindApplicationsMethod getFindApplicationsMethodImplementation() {
        return Ey;
    }

    public static void setFindApplicationsMethodImplementation(DirectoryTypeFindApplicationsMethod directoryTypeFindApplicationsMethod) {
        Ey = directoryTypeFindApplicationsMethod;
    }

    @Override
    @Mandatory
    public UaMethod getRegisterApplicationNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/GDS/", "RegisterApplication");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract NodeId onRegisterApplication(ServiceContext var1, ApplicationRecordDataType var2) throws StatusException;

    @Override
    public NodeId registerApplication(ApplicationRecordDataType applicationRecordDataType) throws StatusException {
        return this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, applicationRecordDataType);
    }

    private NodeId a(ServiceContext serviceContext, ApplicationRecordDataType applicationRecordDataType) throws StatusException {
        DirectoryTypeRegisterApplicationMethod directoryTypeRegisterApplicationMethod = DirectoryTypeNodeBase.getRegisterApplicationMethodImplementation();
        if (directoryTypeRegisterApplicationMethod != null) {
            return directoryTypeRegisterApplicationMethod.registerApplication(serviceContext, (DirectoryTypeNode)this, applicationRecordDataType);
        }
        return this.onRegisterApplication(serviceContext, applicationRecordDataType);
    }

    public static DirectoryTypeRegisterApplicationMethod getRegisterApplicationMethodImplementation() {
        return Ez;
    }

    public static void setRegisterApplicationMethodImplementation(DirectoryTypeRegisterApplicationMethod directoryTypeRegisterApplicationMethod) {
        Ez = directoryTypeRegisterApplicationMethod;
    }

    @Override
    @Mandatory
    public UaMethod getUpdateApplicationNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/GDS/", "UpdateApplication");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onUpdateApplication(ServiceContext var1, ApplicationRecordDataType var2) throws StatusException;

    @Override
    public void updateApplication(ApplicationRecordDataType applicationRecordDataType) throws StatusException {
        this.b(ServiceContext.INTERNAL_OPERATION_CONTEXT, applicationRecordDataType);
    }

    private void b(ServiceContext serviceContext, ApplicationRecordDataType applicationRecordDataType) throws StatusException {
        DirectoryTypeUpdateApplicationMethod directoryTypeUpdateApplicationMethod = DirectoryTypeNodeBase.getUpdateApplicationMethodImplementation();
        if (directoryTypeUpdateApplicationMethod != null) {
            directoryTypeUpdateApplicationMethod.updateApplication(serviceContext, (DirectoryTypeNode)this, applicationRecordDataType);
        } else {
            this.onUpdateApplication(serviceContext, applicationRecordDataType);
        }
    }

    public static DirectoryTypeUpdateApplicationMethod getUpdateApplicationMethodImplementation() {
        return EA;
    }

    public static void setUpdateApplicationMethodImplementation(DirectoryTypeUpdateApplicationMethod directoryTypeUpdateApplicationMethod) {
        EA = directoryTypeUpdateApplicationMethod;
    }

    @Override
    @Mandatory
    public UaMethod getUnregisterApplicationNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/GDS/", "UnregisterApplication");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onUnregisterApplication(ServiceContext var1, NodeId var2) throws StatusException;

    @Override
    public void unregisterApplication(NodeId nodeId) throws StatusException {
        this.b(ServiceContext.INTERNAL_OPERATION_CONTEXT, nodeId);
    }

    private void b(ServiceContext serviceContext, NodeId nodeId) throws StatusException {
        DirectoryTypeUnregisterApplicationMethod directoryTypeUnregisterApplicationMethod = DirectoryTypeNodeBase.getUnregisterApplicationMethodImplementation();
        if (directoryTypeUnregisterApplicationMethod != null) {
            directoryTypeUnregisterApplicationMethod.unregisterApplication(serviceContext, (DirectoryTypeNode)this, nodeId);
        } else {
            this.onUnregisterApplication(serviceContext, nodeId);
        }
    }

    public static DirectoryTypeUnregisterApplicationMethod getUnregisterApplicationMethodImplementation() {
        return EB;
    }

    public static void setUnregisterApplicationMethodImplementation(DirectoryTypeUnregisterApplicationMethod directoryTypeUnregisterApplicationMethod) {
        EB = directoryTypeUnregisterApplicationMethod;
    }

    @Override
    @Mandatory
    public UaMethod getGetApplicationNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/GDS/", "GetApplication");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract ApplicationRecordDataType onGetApplication(ServiceContext var1, NodeId var2) throws StatusException;

    @Override
    public ApplicationRecordDataType getApplication(NodeId nodeId) throws StatusException {
        return this.c(ServiceContext.INTERNAL_OPERATION_CONTEXT, nodeId);
    }

    private ApplicationRecordDataType c(ServiceContext serviceContext, NodeId nodeId) throws StatusException {
        DirectoryTypeGetApplicationMethod directoryTypeGetApplicationMethod = DirectoryTypeNodeBase.getGetApplicationMethodImplementation();
        if (directoryTypeGetApplicationMethod != null) {
            return directoryTypeGetApplicationMethod.getApplication(serviceContext, (DirectoryTypeNode)this, nodeId);
        }
        return this.onGetApplication(serviceContext, nodeId);
    }

    public static DirectoryTypeGetApplicationMethod getGetApplicationMethodImplementation() {
        return EC;
    }

    public static void setGetApplicationMethodImplementation(DirectoryTypeGetApplicationMethod directoryTypeGetApplicationMethod) {
        EC = directoryTypeGetApplicationMethod;
    }

    @Override
    @Mandatory
    public UaMethod getQueryApplicationsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/GDS/", "QueryApplications");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract DirectoryType.QueryApplicationsMethodOutputs onQueryApplications(ServiceContext var1, UnsignedInteger var2, UnsignedInteger var3, String var4, String var5, UnsignedInteger var6, String var7, String[] var8) throws StatusException;

    @Override
    public DirectoryType.QueryApplicationsMethodOutputs queryApplications(UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2, String string, String string2, UnsignedInteger unsignedInteger3, String string3, String[] stringArray) throws StatusException {
        return this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, unsignedInteger, unsignedInteger2, string, string2, unsignedInteger3, string3, stringArray);
    }

    private DirectoryType.QueryApplicationsMethodOutputs a(ServiceContext serviceContext, UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2, String string, String string2, UnsignedInteger unsignedInteger3, String string3, String[] stringArray) throws StatusException {
        DirectoryTypeQueryApplicationsMethod directoryTypeQueryApplicationsMethod = DirectoryTypeNodeBase.getQueryApplicationsMethodImplementation();
        if (directoryTypeQueryApplicationsMethod != null) {
            return directoryTypeQueryApplicationsMethod.queryApplications(serviceContext, (DirectoryTypeNode)this, unsignedInteger, unsignedInteger2, string, string2, unsignedInteger3, string3, stringArray);
        }
        return this.onQueryApplications(serviceContext, unsignedInteger, unsignedInteger2, string, string2, unsignedInteger3, string3, stringArray);
    }

    public static DirectoryTypeQueryApplicationsMethod getQueryApplicationsMethodImplementation() {
        return ED;
    }

    public static void setQueryApplicationsMethodImplementation(DirectoryTypeQueryApplicationsMethod directoryTypeQueryApplicationsMethod) {
        ED = directoryTypeQueryApplicationsMethod;
    }

    @Override
    @Mandatory
    public UaMethod getQueryServersNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/GDS/", "QueryServers");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract DirectoryType.QueryServersMethodOutputs onQueryServers(ServiceContext var1, UnsignedInteger var2, UnsignedInteger var3, String var4, String var5, String var6, String[] var7) throws StatusException;

    @Override
    public DirectoryType.QueryServersMethodOutputs queryServers(UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2, String string, String string2, String string3, String[] stringArray) throws StatusException {
        return this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, unsignedInteger, unsignedInteger2, string, string2, string3, stringArray);
    }

    private DirectoryType.QueryServersMethodOutputs a(ServiceContext serviceContext, UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2, String string, String string2, String string3, String[] stringArray) throws StatusException {
        DirectoryTypeQueryServersMethod directoryTypeQueryServersMethod = DirectoryTypeNodeBase.getQueryServersMethodImplementation();
        if (directoryTypeQueryServersMethod != null) {
            return directoryTypeQueryServersMethod.queryServers(serviceContext, (DirectoryTypeNode)this, unsignedInteger, unsignedInteger2, string, string2, string3, stringArray);
        }
        return this.onQueryServers(serviceContext, unsignedInteger, unsignedInteger2, string, string2, string3, stringArray);
    }

    public static DirectoryTypeQueryServersMethod getQueryServersMethodImplementation() {
        return EE;
    }

    public static void setQueryServersMethodImplementation(DirectoryTypeQueryServersMethod directoryTypeQueryServersMethod) {
        EE = directoryTypeQueryServersMethod;
    }
}

