/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.typedictionary;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.utils.AbstractStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicStructure
extends AbstractStructure {
    private static final Logger logger = LoggerFactory.getLogger(DynamicStructure.class);
    private final StructureSpecification Da;
    private Map<String, Object> ev = new HashMap<String, Object>();

    public static Builder builder(StructureSpecification structureSpecification) {
        return new Builder(new DynamicStructure(structureSpecification));
    }

    public DynamicStructure(StructureSpecification structureSpecification) {
        if (structureSpecification == null) {
            throw new IllegalArgumentException("Given specification cannot be null");
        }
        this.Da = structureSpecification;
    }

    @Override
    public void clear() {
        this.ev.clear();
    }

    @Override
    public DynamicStructure clone() {
        DynamicStructure dynamicStructure = (DynamicStructure)super.clone();
        dynamicStructure.ev = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.ev.entrySet()) {
            dynamicStructure.ev.put(entry.getKey(), StructureUtils.clone(entry.getValue()));
        }
        return dynamicStructure;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DynamicStructure dynamicStructure = (DynamicStructure)object;
        if (!this.Da.equals(dynamicStructure.Da)) {
            return false;
        }
        if (!this.ev.keySet().equals(dynamicStructure.ev.keySet())) {
            return false;
        }
        for (Map.Entry<String, Object> entry : this.ev.entrySet()) {
            if (StructureUtils.scalarOrArrayEquals(entry.getValue(), dynamicStructure.ev.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object get(FieldSpecification fieldSpecification) {
        this.b(fieldSpecification);
        return this.ev.get(fieldSpecification.getName());
    }

    @Override
    public Object get(String string) {
        FieldSpecification fieldSpecification = this.av(string);
        return this.ev.get(fieldSpecification.getName());
    }

    @Override
    @Deprecated
    public ExpandedNodeId getBinaryEncodeId() {
        if (this.Da.getBinaryEncodeId() == null) {
            logger.warn("DynamicStructure with Specification {} does not support binary encoding", (Object)this.Da);
            return null;
        }
        return this.Da.getBinaryEncodeId().asExpandedNodeId();
    }

    public List<String> getFieldNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (FieldSpecification fieldSpecification : this.getFields()) {
            arrayList.add(fieldSpecification.getName());
        }
        return Collections.unmodifiableList(arrayList);
    }

    public List<FieldSpecification> getFields() {
        return Collections.unmodifiableList(this.Da.getFields());
    }

    @Deprecated
    public StructureSpecification getSpecification() {
        return this.Da;
    }

    @Override
    @Deprecated
    public ExpandedNodeId getTypeId() {
        return this.Da.getTypeId().asExpandedNodeId();
    }

    @Override
    @Deprecated
    public ExpandedNodeId getXmlEncodeId() {
        if (this.Da.getXmlEncodeId() == null) {
            return null;
        }
        return this.Da.getXmlEncodeId().asExpandedNodeId();
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + this.Da.hashCode();
        Object[] objectArray = this.ev.values().toArray();
        n3 = 31 * n3 + StructureUtils.hashCode(objectArray);
        return n3;
    }

    @Override
    public void set(FieldSpecification fieldSpecification, Object object) {
        this.b(fieldSpecification);
        this.a(fieldSpecification, object);
        if (StructureSpecification.StructureType.UNION == this.Da.getStructureType() || StructureSpecification.StructureType.UNION_SUBTYPES == this.Da.getStructureType()) {
            this.ev.clear();
        }
        this.ev.put(fieldSpecification.getName(), object);
    }

    @Override
    public void set(String string, Object object) {
        FieldSpecification fieldSpecification = this.av(string);
        this.set(fieldSpecification, object);
    }

    @Override
    public StructureSpecification specification() {
        return this.Da;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this.clone());
    }

    private void b(FieldSpecification fieldSpecification) {
        if (!this.getFields().contains(fieldSpecification)) {
            throw new IllegalArgumentException("The " + this.Da + " of this Structure does not contain: " + fieldSpecification);
        }
    }

    private FieldSpecification av(String string) {
        for (FieldSpecification fieldSpecification : this.getFields()) {
            if (!fieldSpecification.getName().equals(string)) continue;
            return fieldSpecification;
        }
        throw new IllegalArgumentException("This Structure does not contain field named: " + string);
    }

    private void a(FieldSpecification fieldSpecification, Object object) {
        if (object == null) {
            return;
        }
        if (!fieldSpecification.getJavaClass().isAssignableFrom(object.getClass())) {
            throw new IllegalArgumentException("For field:" + fieldSpecification + ", the given value:" + object + ", does not have correct type:" + fieldSpecification.getJavaClass() + ", instead it is:" + object.getClass());
        }
    }

    public static class Builder
    extends AbstractStructure.Builder {
        protected final DynamicStructure delegate;

        protected Builder(DynamicStructure dynamicStructure) {
            this.delegate = dynamicStructure;
        }

        @Override
        public DynamicStructure build() {
            return this.delegate.clone();
        }

        @Override
        public Object get(FieldSpecification fieldSpecification) {
            return this.delegate.get(fieldSpecification);
        }

        @Override
        public Builder set(FieldSpecification fieldSpecification, Object object) {
            this.delegate.set(fieldSpecification, object);
            return this;
        }

        @Override
        public StructureSpecification specification() {
            return this.delegate.specification();
        }
    }
}

