/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils.bytebuffer;

import com.prosysopc.ua.stack.utils.bytebuffer.IBinaryReadable;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class InputStreamReadable
implements IBinaryReadable {
    ByteOrder CF = ByteOrder.LITTLE_ENDIAN;
    InputStream is;
    long limit;
    long CQ;

    public InputStreamReadable(InputStream inputStream, long l2) {
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        this.is = inputStream;
        this.limit = l2;
    }

    @Override
    public byte get() throws IOException {
        return (byte)this.etU();
    }

    @Override
    public void get(byte[] byArray) throws IOException {
        this.get(byArray, 0, byArray.length);
    }

    @Override
    public void get(byte[] byArray, int n2, int n3) throws IOException {
        while (n3 > 0) {
            int n4 = this.is.read(byArray, n2, n3);
            if (n4 == -1) {
                throw new EOFException();
            }
            this.CQ += (long)n4;
            n2 += n4;
            n3 -= n4;
        }
    }

    @Override
    public void get(ByteBuffer byteBuffer) throws IOException {
        while (byteBuffer.hasRemaining()) {
            byteBuffer.put((byte)this.etU());
        }
    }

    @Override
    public void get(ByteBuffer byteBuffer, int n2) throws IOException {
        byte[] byArray = new byte[n2];
        this.get(byArray, 0, n2);
        byteBuffer.put(byArray);
    }

    @Override
    public double getDouble() throws IOException {
        return Double.longBitsToDouble(this.getLong());
    }

    @Override
    public float getFloat() throws IOException {
        return Float.intBitsToFloat(this.getInt());
    }

    @Override
    public int getInt() throws IOException {
        if (this.CF == ByteOrder.BIG_ENDIAN) {
            return this.etU() << 24 | this.etU() << 16 | this.etU() << 8 | this.etU();
        }
        return this.etU() | this.etU() << 8 | this.etU() << 16 | this.etU() << 24;
    }

    @Override
    public long getLong() throws IOException {
        if (this.CF == ByteOrder.BIG_ENDIAN) {
            return (long)this.etU() << 56 | (long)this.etU() << 48 | (long)this.etU() << 40 | (long)this.etU() << 32 | (long)this.etU() << 24 | (long)this.etU() << 16 | (long)this.etU() << 8 | (long)this.etU();
        }
        return (long)this.etU() | (long)this.etU() << 8 | (long)this.etU() << 16 | (long)this.etU() << 24 | (long)this.etU() << 32 | (long)this.etU() << 40 | (long)this.etU() << 48 | (long)this.etU() << 56;
    }

    @Override
    public short getShort() throws IOException {
        if (this.CF == ByteOrder.BIG_ENDIAN) {
            return (short)(this.etU() << 8 | this.etU());
        }
        return (short)(this.etU() | this.etU() << 8);
    }

    @Override
    public long limit() {
        return this.limit;
    }

    @Override
    public ByteOrder order() {
        return this.CF;
    }

    @Override
    public void order(ByteOrder byteOrder) {
        this.CF = byteOrder;
    }

    @Override
    public long position() {
        return this.CQ;
    }

    public void skip(long l2) throws IOException {
        this.is.skip(l2);
    }

    int etU() throws IOException {
        int n2 = this.is.read();
        if (n2 == -1) {
            throw new EOFException();
        }
        ++this.CQ;
        return n2 & 0xFF;
    }
}

