/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils.bytebuffer;

import com.prosysopc.ua.stack.utils.bytebuffer.ByteBufferFactory;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.LinkedList;

public class ByteQueue {
    private static final ByteBuffer CH = ByteBuffer.allocate(0);
    private static final ByteBuffer[] CI = new ByteBuffer[0];
    ByteBufferFactory CJ = ByteBufferFactory.LITTLE_ENDIAN_HEAP_BYTEBUFFER_FACTORY;
    int chunkSize = 4096;
    long CK;
    long CL;
    long CM = Long.MAX_VALUE;
    ByteOrder CF = ByteOrder.LITTLE_ENDIAN;
    LinkedList<ByteBuffer> list = new LinkedList();
    ByteBuffer CN;
    ByteBuffer CO;

    private static void copy(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n2) {
        int n3 = byteBuffer.limit();
        int n4 = byteBuffer2.limit();
        byteBuffer.limit(byteBuffer.position() + n2);
        byteBuffer2.limit(byteBuffer2.position() + n2);
        byteBuffer2.put(byteBuffer);
        byteBuffer.limit(n3);
        byteBuffer2.limit(n4);
    }

    private static void copyRemaining(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        int n2 = Math.min(byteBuffer.remaining(), byteBuffer2.remaining());
        ByteQueue.copy(byteBuffer, byteBuffer2, n2);
    }

    public ByteQueue() {
    }

    public ByteQueue(int n2) {
        this.chunkSize = n2;
    }

    public void clear() {
        this.CL = 0L;
        this.CK = 0L;
        this.list.clear();
        this.CN = null;
        this.CO = null;
    }

    public void get(byte[] byArray) throws BufferUnderflowException {
        this.get(byArray, 0, byArray.length);
    }

    public void get(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n3 < 0 || n3 > byArray.length - n2) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return;
        }
        if ((long)n3 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        while (n3 > 0) {
            ByteBuffer byteBuffer = this.getReadChunk();
            if (byteBuffer == null) {
                throw new BufferUnderflowException();
            }
            int n4 = Math.min(byteBuffer.remaining(), n3);
            byteBuffer.get(byArray, n2, n4);
            n2 += n4;
            n3 -= n4;
        }
    }

    public void get(ByteBuffer byteBuffer) throws BufferUnderflowException {
        if ((long)byteBuffer.remaining() > this.remaining()) {
            throw new BufferUnderflowException();
        }
        this.get(byteBuffer, byteBuffer.remaining());
    }

    public void get(ByteBuffer byteBuffer, int n2) throws BufferUnderflowException {
        if (n2 > byteBuffer.remaining()) {
            throw new BufferUnderflowException();
        }
        if ((long)n2 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        while (n2 > 0) {
            ByteBuffer byteBuffer2 = this.getReadChunk();
            int n3 = Math.min(byteBuffer2.remaining(), n2);
            ByteQueue.copy(byteBuffer2, byteBuffer, n3);
            n2 -= n3;
        }
    }

    public ByteBuffer get(int n2) throws BufferUnderflowException {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        if ((long)n2 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        if (n2 == 0) {
            return CH;
        }
        int n3 = this.F(n2);
        if (n3 == 1) {
            ByteBuffer byteBuffer = this.getChunks(n2)[0];
            return byteBuffer;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        byteBuffer.order(this.CF);
        this.get(byteBuffer);
        byteBuffer.rewind();
        return byteBuffer;
    }

    public void getAvailable(ByteBuffer byteBuffer) {
        this.get(byteBuffer, Math.min(byteBuffer.remaining(), (int)this.remaining()));
    }

    public ByteBufferFactory getByteBufferFactory() {
        return this.CJ;
    }

    public long getBytesRead() {
        return this.CK + (long)(this.CO == null ? 0 : this.CO.position());
    }

    public long getBytesWritten() {
        return this.CL + (long)(this.CN == null ? 0 : this.CN.position());
    }

    public ByteBuffer[] getChunks(int n2) throws BufferUnderflowException {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        if ((long)n2 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        if (n2 == 0) {
            return CI;
        }
        ByteBuffer[] byteBufferArray = new ByteBuffer[this.F(n2)];
        int n3 = 0;
        ByteBuffer byteBuffer = this.getReadChunk();
        while (byteBuffer != null && n2 > 0) {
            if (n2 < byteBuffer.remaining()) {
                ByteBuffer byteBuffer2 = this.CO.slice();
                byteBuffer2.order(this.CF);
                this.CO.position(this.CO.position() + n2);
                byteBuffer2.limit(n2);
                byteBufferArray[n3++] = byteBuffer2;
                n2 = 0;
            } else {
                this.CK += (long)(byteBuffer.remaining() + byteBuffer.position());
                n2 -= byteBuffer.remaining();
                this.CO = null;
                byteBufferArray[n3++] = byteBuffer.slice().order(this.CF);
            }
            byteBuffer = this.getReadChunk();
        }
        return byteBufferArray;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public ByteBuffer getReadChunk() {
        if (this.CO != null && !this.CO.hasRemaining()) {
            this.CK += (long)this.CO.position();
            this.CO = null;
        }
        if (this.CO != null) {
            return this.CO;
        }
        if (this.list.isEmpty()) {
            this.etT();
        }
        if (!this.list.isEmpty()) {
            this.CO = this.list.removeFirst();
            this.CK -= (long)this.CO.position();
            return this.CO;
        }
        return null;
    }

    public int getWriteableBytesRemaining() {
        return (int)Math.min(Integer.MAX_VALUE, this.CM - this.getBytesWritten());
    }

    public ByteBuffer getWriteChunk() {
        if (this.CN != null && !this.CN.hasRemaining()) {
            this.etT();
        }
        if (this.CN != null) {
            return this.CN;
        }
        int n2 = Math.min(this.getWriteableBytesRemaining(), this.chunkSize);
        if (n2 == 0) {
            throw new BufferOverflowException();
        }
        this.CN = this.CJ.allocate(n2);
        this.CN.order(this.CF);
        return this.CN;
    }

    public long getWriteLimit() {
        return this.CM;
    }

    public boolean hasRemaining() {
        return this.remaining() > 0L;
    }

    public boolean isEmpty() {
        return this.remaining() == 0L;
    }

    public void offer(ByteBuffer byteBuffer) throws BufferOverflowException {
        if (this.getWriteableBytesRemaining() < byteBuffer.remaining()) {
            throw new BufferOverflowException();
        }
        if (!byteBuffer.hasRemaining()) {
            return;
        }
        this.etT();
        this.CL += (long)byteBuffer.remaining();
        this.list.addLast(byteBuffer);
    }

    public void omitAll() {
        if (this.CN != null) {
            this.CL += (long)this.CN.position();
        }
        this.CK = this.CL;
        this.list.clear();
        this.CN = null;
        this.CO = null;
    }

    public ByteOrder order() {
        return this.CF;
    }

    public void order(ByteOrder byteOrder) {
        this.CF = byteOrder;
    }

    public void peek(byte[] byArray) throws BufferUnderflowException {
        this.peek(byArray, 0, byArray.length);
    }

    public void peek(byte[] byArray, int n2, int n3) throws BufferUnderflowException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n3 < 0 || n3 > byArray.length - n2) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return;
        }
        if ((long)n3 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        if (this.CO != null) {
            int n4 = Math.min(this.CO.remaining(), n3);
            this.CO.mark();
            this.CO.get(byArray, n2, n4);
            this.CO.reset();
            n2 += n4;
            if ((n3 -= n4) == 0) {
                return;
            }
        }
        if (!this.list.isEmpty()) {
            Iterator iterator = this.list.iterator();
            while (n3 > 0 && iterator.hasNext()) {
                ByteBuffer byteBuffer = (ByteBuffer)iterator.next();
                int n5 = Math.min(byteBuffer.remaining(), n3);
                byteBuffer.mark();
                byteBuffer.get(byArray, n2, n5);
                byteBuffer.reset();
                n2 += n5;
                n3 -= n5;
            }
        }
        if (this.CN != null) {
            ByteBuffer byteBuffer = (ByteBuffer)this.CN.duplicate().flip();
            byteBuffer.order(this.CF);
            int n6 = Math.min(byteBuffer.remaining(), n3);
            byteBuffer.get(byArray, n2, n6);
            n2 += n6;
            n3 -= n6;
        }
    }

    public void peek(ByteBuffer byteBuffer) throws BufferUnderflowException {
        if ((long)byteBuffer.remaining() > this.remaining()) {
            throw new BufferUnderflowException();
        }
        this.peekAvailable(byteBuffer);
    }

    public ByteBuffer peek(int n2) throws BufferUnderflowException {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        if ((long)n2 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        if (n2 == 0) {
            return CH;
        }
        ByteBuffer[] byteBufferArray = this.peekChunks(n2);
        if (byteBufferArray.length == 1) {
            return byteBufferArray[0];
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        byteBuffer.order(this.CF);
        this.peek(byteBuffer);
        byteBuffer.rewind();
        return byteBuffer;
    }

    public void peekAvailable(ByteBuffer byteBuffer) {
        Object object;
        if (!byteBuffer.hasRemaining()) {
            return;
        }
        if (this.CO != null) {
            this.CO.mark();
            ByteQueue.copyRemaining(this.CO, byteBuffer);
            this.CO.reset();
        }
        if (!byteBuffer.hasRemaining()) {
            return;
        }
        if (!this.list.isEmpty()) {
            object = this.list.iterator();
            while (byteBuffer.hasRemaining() && object.hasNext()) {
                ByteBuffer byteBuffer2 = (ByteBuffer)object.next();
                byteBuffer2.mark();
                ByteQueue.copyRemaining(byteBuffer2, byteBuffer);
                byteBuffer2.reset();
            }
        }
        if (!byteBuffer.hasRemaining()) {
            return;
        }
        if (this.CN != null) {
            object = (ByteBuffer)this.CN.duplicate().flip();
            ((ByteBuffer)object).order(this.CF);
            ByteQueue.copyRemaining((ByteBuffer)object, byteBuffer);
        }
    }

    public ByteBuffer[] peekChunks(int n2) throws BufferUnderflowException {
        Object object;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        if ((long)n2 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        if (n2 == 0) {
            return CI;
        }
        int n3 = n2;
        ByteBuffer[] byteBufferArray = new ByteBuffer[this.F(n2)];
        int n4 = 0;
        if (this.CO != null) {
            object = this.CO.slice();
            ((ByteBuffer)object).order(this.CF);
            if (n3 < ((Buffer)object).remaining()) {
                ((ByteBuffer)object).limit(n3);
                n3 = 0;
            } else {
                n3 -= ((Buffer)object).remaining();
            }
            byteBufferArray[n4++] = object;
        }
        if (!this.list.isEmpty() && n3 > 0) {
            object = this.list.iterator();
            while (n3 > 0 && object.hasNext()) {
                ByteBuffer byteBuffer = ((ByteBuffer)object.next()).slice();
                byteBuffer.order(this.CF);
                if (n3 < byteBuffer.remaining()) {
                    byteBuffer.limit(n3);
                    n3 = 0;
                } else {
                    n3 -= byteBuffer.remaining();
                }
                byteBufferArray[n4++] = byteBuffer;
            }
        }
        if (n3 > 0 && this.CN != null) {
            object = (ByteBuffer)this.CN.duplicate().flip();
            ((ByteBuffer)object).order(this.CF);
            if (n3 < ((Buffer)object).remaining()) {
                ((ByteBuffer)object).limit(n3);
                n3 = 0;
            } else {
                n3 -= ((Buffer)object).remaining();
            }
            byteBufferArray[n4++] = object;
        }
        return byteBufferArray;
    }

    public void put(byte by) {
        this.getWriteChunk().put(by);
    }

    public void put(byte[] byArray) throws BufferOverflowException {
        this.put(byArray, 0, byArray.length);
    }

    public void put(byte[] byArray, int n2, int n3) throws BufferOverflowException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return;
        }
        while (n3 > 0) {
            ByteBuffer byteBuffer = this.getWriteChunk();
            int n4 = Math.min(byteBuffer.remaining(), n3);
            byteBuffer.put(byArray, n2, n4);
            n2 += n4;
            n3 -= n4;
        }
    }

    public void put(ByteBuffer byteBuffer) {
        this.put(byteBuffer, byteBuffer.remaining());
    }

    public void put(ByteBuffer byteBuffer, int n2) {
        while (n2 > 0) {
            ByteBuffer byteBuffer2 = this.getWriteChunk();
            int n3 = Math.min(byteBuffer2.remaining(), n2);
            ByteQueue.copy(byteBuffer, byteBuffer2, n3);
            n2 -= n3;
        }
    }

    public long remaining() {
        return this.getBytesWritten() - this.getBytesRead();
    }

    public void setByteBufferFactory(ByteBufferFactory byteBufferFactory) {
        this.CJ = byteBufferFactory;
    }

    public void setChunkSize(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("chunk size < 1");
        }
        this.chunkSize = n2;
    }

    public void setWriteLimit(long l2) {
        this.CM = l2;
    }

    public void skip(int n2) throws BufferOverflowException {
        if ((long)n2 > this.remaining()) {
            throw new BufferOverflowException();
        }
        while (n2 > 0) {
            ByteBuffer byteBuffer = this.getReadChunk();
            int n3 = Math.min(byteBuffer.remaining(), n2);
            byteBuffer.position(byteBuffer.position() + n3);
            n2 -= n3;
        }
    }

    public String toString() {
        return "ByteQueue (read=" + this.getBytesRead() + ", written=" + this.getBytesWritten() + ")";
    }

    private int F(int n2) {
        int n3 = 0;
        if (n2 == 0) {
            return n3;
        }
        if (this.CO != null) {
            n2 -= Math.min(this.CO.remaining(), n2);
            ++n3;
        }
        if (n2 == 0) {
            return n3;
        }
        if (!this.list.isEmpty()) {
            Iterator iterator = this.list.iterator();
            while (n2 > 0 && iterator.hasNext()) {
                ByteBuffer byteBuffer = (ByteBuffer)iterator.next();
                n2 -= Math.min(byteBuffer.remaining(), n2);
                ++n3;
            }
        }
        if (n2 == 0) {
            return n3;
        }
        if (this.CN != null) {
            ++n3;
        }
        return n3;
    }

    private void etT() {
        if (this.CN == null) {
            return;
        }
        if (this.CN.position() == 0) {
            return;
        }
        if (!this.CN.hasRemaining()) {
            this.CL += (long)this.CN.position();
            this.CN.flip();
            this.list.addLast(this.CN);
            this.CN = null;
            return;
        }
        this.CL += (long)this.CN.position();
        ByteBuffer byteBuffer = this.CN;
        this.CN = this.CN.slice();
        this.CN.order(this.CF);
        byteBuffer.flip();
        this.list.addLast(byteBuffer);
    }
}

